package cn.zoecloud.core.model;

import java.util.List;

import static cn.zoecloud.core.internal.ZoeCloudConstants.COMMAND_REQUEST_SYNC_DEFAULT_TIMEOUT;

/**
 * 命令请求基础类
 * @author Leo
 */
public abstract class BaseCommandRequest {
    private List<String> terminalIds;

    /**
     * 超时时间取值范围为：1 ~ 5 (秒)
     */
    private Integer timeout = COMMAND_REQUEST_SYNC_DEFAULT_TIMEOUT;

    public List<String> getTerminalIds() {
        return terminalIds;
    }

    public void setTerminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public BaseCommandRequest(List<String> terminalIds) {
        this(terminalIds, COMMAND_REQUEST_SYNC_DEFAULT_TIMEOUT);
    }

    public BaseCommandRequest(List<String> terminalIds, int timeout) {
        this.setTimeout(timeout);
        this.setTerminalIds(terminalIds);
    }
}
