package cn.zoecloud.core.auth;

import cn.zoecloud.core.internal.ZoeCloudConstants;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.util.HttpUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 请求签名的默认实现
 * @author Leo
 */
public class DefaultRequestSigner implements RequestSigner {
    private String contentPath;

    private String appKey, appSecret;

    public DefaultRequestSigner(Credential credential) {
        this(credential, "");
    }

    public DefaultRequestSigner(Credential credential, String contentPath) {
        this.contentPath = contentPath;

        if (credential != null) {
            this.appKey = credential.getAppKey();
            this.appSecret = credential.getAppSecret();
        }

    }

    @Override
    public void sign(RequestMessage request) {
        if (StringUtils.isBlank(this.appKey) || StringUtils.isBlank(this.appSecret)) {
            return;
        }

        HmacUtils hmacUtils = new HmacUtils(HmacAlgorithms.HMAC_MD5, this.appSecret);
        String appKey = this.appKey;
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        String text = appKey + "," + timestamp;
        String uri = request.getMethod().toString() + this.contentPath + request.getResourcePath();
        String param = HttpUtil.paramToQueryString(request.getParameters(), ZoeCloudConstants.DEFAULT_ENCODING);
        if (StringUtils.isBlank(param)) {
            param = "";
        } else {
            param = "?" + param;
        }
        String body = request.getBody();
        if (body == null) {
            body = "";
        }
        String hmac = hmacUtils.hmacHex(text + "," + uri + param + body);
        text += "," + hmac;
        String base64 = Base64.encodeBase64String(text.getBytes());
        String token = HttpUtil.urlEncode(base64, ZoeCloudConstants.DEFAULT_ENCODING);
        request.addHeader(ZoeCloudConstants.ZOEHOO_CLOUD_TOKEN_NAME, token);
    }
}
