package cn.zoecloud.core;

import cn.zoecloud.core.model.*;

/**
 * 中航云服务SDK调用接口
 * @author Leo
 */
public interface ZoeCloud {
    /**
     * 分页获取分组数据
     *
     * @param request 请求信息
     * @return 分组列表及分页信息
     */
    GetGroupPageResult getGroupPage(GetGroupPageRequest request);

    /**
     * 获取指定ID的单个设备数据
     *
     * @param request 请求信息
     * @return 设备数据
     */
    GetTerminalSingleResult getTerminal(GetTerminalSingleRequest request);

    /**
     * 分页获取设备信息，可以提供过滤数据进行筛选
     * @param request 请求信息
     * @return 设备列表及分页信息
     */
    GetTerminalPageResult getTerminalPage(GetTerminalPageRequest request);

    /**
     * 根据命令ID获取命令执行结果
     * @param request 请求信息
     * @return 命令执行结果
     */
    CommandResultListResult getCommandResultList(GetCommandResultListRequest request);

    /**
     * 发送打开屏幕命令
     * @param request 请求信息
     * @return 命令执行结果
     */
    CommandResultListResult commandOpenScreen(CommandOpenScreenRequest request);

    /**
     * 发送关闭屏幕命令
     * @param request 请求信息
     * @return 命令执行结果
     */
    CommandResultListResult commandCloseScreen(CommandCloseScreenRequest request);

    /**
     * 发送获取屏幕状态的命令
     * @param request 请求信息
     * @return 命令执行结果
     */
    CommandResultListResult commandFetchScreenStatus(CommandFetchScreenStatusRequest request);

    /**
     * 发送获取节目信息的命令
     * @param request 请求信息
     * @return 命令执行结果
     */
    CommandResultListResult commandFetchPrograms(CommandFetchProgramsRequest request);

    /**
     * 发送屏幕截图的命令
     * @param request 请求信息
     * @return 命令执行结果
     */
    CommandResultListResult commandCaptureScreen(CommandCaptureScreenRequest request);

    /**
     * 分页获取节目布局数据
     *
     * @param request 请求信息
     * @return 节目布局列表及分页信息
     */
    GetLayoutPageResult getLayoutPage(GetLayoutPageRequest request);

    /**
     * 发布节目
     * @param request
     * @return
     */
    ProgramPublishResult programPublish(ProgramPublishRequest request);

    /**
     * 获取节目发布状态
     * @param request
     * @return
     */
    GetProgramPublishStatusResult getProgramPublishStatus(GetProgramPublishStatusRequest request);

    /**
     * 获取节目发布详情
     * @param request
     * @return
     */
    GetProgramPublishDetailResult getProgramPublishDetail(GetProgramPublishDetailRequest request);

    /**
     * 停止实例
     */
    void shutdown();
}
