/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.util;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.utils.UtilMisc;
import com.sprite.utils.UtilString;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseUtil {
    private static Logger logger = LoggerFactory.getLogger(DatabaseUtil.class);
    private DataSource dataSource;
    private EntityScriptExecutor scriptExecutor;

    public static String namespace(String catalog, String schema) {
        return UtilString.place((String)"{}.{}", (Object[])new Object[]{catalog != null ? catalog.toLowerCase() : "", schema != null ? schema.toLowerCase() : ""});
    }

    public static String getNamespace(Connection connection) {
        String catalog = null;
        String schema = null;
        try {
            catalog = connection.getCatalog();
        }
        catch (Exception e) {
            logger.warn("[getCatalog] {}", (Throwable)e);
        }
        try {
            schema = connection.getSchema();
        }
        catch (Exception e) {
            logger.warn("[getSchema] {}", (Throwable)e);
        }
        return DatabaseUtil.namespace(catalog, schema);
    }

    public void checkDb(List<ModelEntity> entityList) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        DbInfo dbInfo = this.getDbInfo(connection);
        String namespace = DatabaseUtil.getNamespace(connection);
        LinkedList<ModelEntity> listToCreate = new LinkedList<ModelEntity>();
        LinkedList<ColumnCheckInfo> listToadd = new LinkedList<ColumnCheckInfo>();
        DbObjects colums = dbInfo.getColums(namespace);
        DbObjects tables = dbInfo.getTables(namespace);
        for (ModelEntity modelEntity : entityList) {
            String tableName = modelEntity.getTableName().toLowerCase();
            if (tables == null || !tables.contains(tableName)) {
                listToCreate.add(modelEntity);
                continue;
            }
            for (ModelField modelField : modelEntity.getFields()) {
                if (colums != null && colums.contains(UtilString.place((String)"{}.{}", (Object[])new Object[]{tableName, modelField.getColName().toLowerCase()}))) continue;
                listToadd.add(new ColumnCheckInfo(tableName, modelField.getColName(), modelField.getType()));
            }
        }
        for (ModelEntity modelEntity : listToCreate) {
            this.scriptExecutor.execute(new InsertTableScript(modelEntity));
            logger.info("create table :{}", (Object)modelEntity.getTableName());
        }
        for (ColumnCheckInfo columnCheckInfo : listToadd) {
            this.scriptExecutor.execute(new AddColumnScript(columnCheckInfo));
            logger.info("add column :{}, table:{} ", (Object)columnCheckInfo.columnName, (Object)columnCheckInfo.tableName);
        }
    }

    private DbInfo getDbInfo(Connection connection) throws SQLException {
        DbInfo dbInfo = new DbInfo();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tableSet = databaseMetaData.getColumns(null, "%", "%", "%");
        while (tableSet.next()) {
            String catalog = tableSet.getString("TABLE_CAT");
            String schema = tableSet.getString("TABLE_SCHEM");
            String table = tableSet.getString("TABLE_NAME").toLowerCase();
            String column = tableSet.getString("COLUMN_NAME").toLowerCase();
            String namespace = DatabaseUtil.namespace(catalog, schema);
            DbObjects dbObjects = dbInfo.getTables(namespace);
            if (dbObjects == null) {
                dbObjects = new DbObjects(catalog, schema);
                dbInfo.addTables(dbObjects);
            }
            dbObjects.add(table);
            dbObjects = dbInfo.getColums(namespace);
            if (dbObjects == null) {
                dbObjects = new DbObjects(catalog, schema);
                dbInfo.addColumns(dbObjects);
            }
            dbObjects.add(UtilString.place((String)"{}.{}", (Object[])new Object[]{table, column}));
        }
        return dbInfo;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public EntityScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(EntityScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    private static class AddColumnScript
    implements EntityScript {
        List<ColumnCheckInfo> columnList;

        public AddColumnScript(ColumnCheckInfo columnList) {
            this.columnList = UtilMisc.toList((Object)columnList);
        }

        @Override
        public DataScriptStatement getStatement() {
            DataScriptStatement scriptStatement = new DataScriptStatement();
            for (ColumnCheckInfo column : this.columnList) {
                scriptStatement.append("ALTER  TABLE ").append(column.tableName).append(" ADD ").append(column.columnName);
                scriptStatement.append(" ").append(ModelEntityUtil.getFieldType(column.type).getSqlType()).append(";");
            }
            return scriptStatement;
        }
    }

    private static class InsertTableScript
    implements EntityScript {
        List<ModelEntity> entityList;

        public InsertTableScript(ModelEntity modelEntity) {
            this.entityList = UtilMisc.toList((Object)modelEntity);
        }

        @Override
        public DataScriptStatement getStatement() {
            DataScriptStatement scriptStatement = new DataScriptStatement();
            for (ModelEntity entity : this.entityList) {
                scriptStatement.append("CREATE TABLE ").append(entity.getTableName()).append("(");
                List<ModelField> fields = entity.getFields();
                int lg = fields.size();
                for (ModelField modelField : fields) {
                    scriptStatement.append(modelField.getColName()).append(" ").append(ModelEntityUtil.getFieldType(modelField.getType()).getSqlType());
                    if (lg > 1) {
                        scriptStatement.append(",");
                    }
                    --lg;
                }
                if (!entity.getKeys().isEmpty()) {
                    scriptStatement.append(",PRIMARY KEY(");
                    lg = entity.getKeys().size();
                    for (ModelField modelField : entity.getKeys()) {
                        scriptStatement.append(modelField.getColName());
                        if (lg > 1) {
                            scriptStatement.append(",");
                        }
                        --lg;
                    }
                    scriptStatement.append(")");
                }
                scriptStatement.append(");");
            }
            return scriptStatement;
        }
    }

    private static class ColumnCheckInfo {
        public String tableName;
        public String columnName;
        public String type;

        public ColumnCheckInfo(String tableName, String columnName, String type) {
            this.tableName = tableName;
            this.columnName = columnName;
            this.type = type;
        }
    }

    private static class DbObjects
    extends HashSet<String> {
        private String namespace;
        private String catalog;
        private String schema;

        DbObjects(String catalog, String schema) {
            this.catalog = catalog;
            this.schema = schema;
            this.namespace = DatabaseUtil.namespace(catalog, schema);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }
    }

    private static class DbInfo {
        private Map<String, DbObjects> tables = new HashMap<String, DbObjects>();
        private Map<String, DbObjects> columns = new HashMap<String, DbObjects>();

        private DbInfo() {
        }

        public DbObjects getTables(String namespace) {
            return this.tables.get(namespace);
        }

        public DbObjects getColums(String namespace) {
            return this.columns.get(namespace);
        }

        public void addTables(DbObjects tables) {
            this.tables.put(tables.getNamespace(), tables);
        }

        public void addColumns(DbObjects columns) {
            this.columns.put(columns.getNamespace(), columns);
        }
    }
}

