/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.script;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityCondition;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.condition.MultiOperateValue;
import com.sprite.framework.entity.model.ModelEntityView;
import com.sprite.framework.entity.script.EntityAlias;
import com.sprite.framework.entity.script.EntityFieldAlias;
import com.sprite.framework.entity.script.EntityFieldAliasBuilder;
import com.sprite.framework.entity.script.EntityScriptFunction;
import com.sprite.framework.entity.script.EntityView;
import java.util.List;

public final class EntityViewLink
implements EntityFieldAliasBuilder,
MultiOperateValue {
    protected String code;
    protected EntityAlias entityAlias;
    protected EntityView entityView;
    protected String alias;
    protected EntityCondition onCondition;

    public EntityViewLink(String code, EntityView entityView, String alias, EntityCondition onCondition) {
        this.code = code;
        this.alias = alias;
        this.entityView = entityView;
        this.onCondition = onCondition;
    }

    public EntityViewLink(String code, String entityName, String alias, EntityCondition onCondition) {
        this.code = code;
        this.alias = alias;
        this.entityAlias = new EntityAlias(entityName, alias);
        this.onCondition = onCondition;
    }

    @Override
    public boolean hasField(String field) {
        return this.getEntityFieldAliasBuilder().hasField(field);
    }

    @Override
    public String resolveFieldPath(String path) {
        return this.getEntityFieldAliasBuilder().resolveFieldPath(path);
    }

    @Override
    public EntityFieldAlias buildFieldAlias(String fieldName, String fieldAlias, EntityScriptFunction function) {
        return this.getEntityFieldAliasBuilder().buildFieldAlias(fieldName, fieldAlias, function);
    }

    @Override
    public List<EntityFieldAlias> buildAllFieldAlias() {
        return this.getEntityFieldAliasBuilder().buildAllFieldAlias();
    }

    private EntityFieldAliasBuilder getEntityFieldAliasBuilder() {
        if (this.entityView != null) {
            return this.entityView;
        }
        if (this.entityAlias != null) {
            return this.entityAlias;
        }
        return null;
    }

    @Override
    public void makeStatement(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        if (this.entityView != null) {
            statement.append(" (");
            this.entityView.makeStatement(statement, modelViewEntity);
            statement.append(" )");
        }
        if (this.entityAlias != null) {
            this.entityAlias.makeStatement(statement, modelViewEntity);
        }
        statement.append(" AS ").append(this.alias);
    }
}

