/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity;

import com.sprite.framework.entity.Delegator;
import com.sprite.framework.entity.EntityCondition;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.EntityInterceptor;
import com.sprite.framework.entity.EntityKey;
import com.sprite.framework.entity.EntityObject;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.IdGenerator;
import com.sprite.framework.entity.QueryArgs;
import com.sprite.framework.entity.condition.EntityFieldMap;
import com.sprite.framework.entity.idgenerator.SequenceGenerator;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.script.EntityDeleteScript;
import com.sprite.framework.entity.script.EntitySelectScript;
import com.sprite.framework.entity.script.EntityUpdateScript;
import com.sprite.utils.UtilBeans;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilMisc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericDelegator
implements Delegator {
    private EntityInterceptor entityInterceptor;
    private EntityScriptExecutor scriptExecutor;
    private volatile Map<String, IdGenerator> generators = new HashMap<String, IdGenerator>();

    public void setScriptExecutor(EntityScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
        this.addGenerator(new SequenceGenerator(scriptExecutor, this));
    }

    public void setEntityInterceptor(EntityInterceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    @Override
    public <T> void store(String entityName, T entity) throws EntityException {
        if (entity == null) {
            return;
        }
        Map fields = null;
        fields = Map.class.isInstance(entity) ? (Map)UtilMisc.cast(entity) : UtilBeans.toMap(entity);
        ModelEntity modelEntity = ModelEntityUtil.getModelEntity(entityName);
        List<ModelField> keys = modelEntity.getKeys();
        EntityKey entityKey = new EntityKey();
        for (ModelField field : keys) {
            Object value = fields.get(field.getFieldName());
            if (value == null) continue;
            entityKey.put(field.getFieldName(), value);
        }
        EntityScript script = null;
        if (!entityKey.isEmpty()) {
            EntityFieldMap whereCondition = EntityCondition.makeCondition(entityKey);
            if (this.count(entityName, whereCondition) > 0L) {
                if (this.entityInterceptor != null) {
                    this.entityInterceptor.update(fields);
                }
                for (ModelField field : keys) {
                    fields.remove(field.getFieldName());
                }
                fields.remove("createdStamp");
                if (modelEntity.hasField("updatedStamp")) {
                    fields.put("updatedStamp", System.currentTimeMillis());
                }
                script = EntityScript.update(entityName, fields, whereCondition);
            }
        } else {
            this.setEntityId(entityName, entity, fields);
        }
        if (script == null) {
            if (modelEntity.hasField("createdStamp")) {
                fields.put("createdStamp", System.currentTimeMillis());
            }
            if (this.entityInterceptor != null) {
                this.entityInterceptor.save(fields);
            }
            script = EntityScript.insert(entityName, fields);
        }
        try {
            this.scriptExecutor.execute(script);
        }
        catch (Exception e) {
            throw EntityException.getInstance(e);
        }
    }

    @Override
    public <T> void storeAll(String entityName, List<T> entities) throws EntityException {
        if (UtilCollection.isNotEmpty(entities)) {
            try {
                for (T entity : entities) {
                    this.store(entityName, entity);
                }
            }
            catch (Exception e) {
                throw EntityException.getInstance(e);
            }
        }
    }

    public void addGenerator(IdGenerator generator) {
        if (this.generators.put(generator.name(), generator) != null) {
            throw new EntityException("IdGenerator[" + generator.name() + "] exists");
        }
    }

    public void addGenerator(List<IdGenerator> generators) {
        if (UtilCollection.isEmpty(generators)) {
            return;
        }
        for (IdGenerator generator : generators) {
            this.addGenerator(generator);
        }
    }

    private Map<String, IdGenerator> getGenerators() {
        return this.generators;
    }

    private void setEntityId(String entityName, Object entity, Map<String, Object> fields) {
        if (entity == null) {
            return;
        }
        List<ModelField> keys = ModelEntityUtil.getModelEntity(entityName).getKeys();
        if (UtilCollection.isEmpty(keys)) {
            return;
        }
        for (ModelField keyField : keys) {
            IdGenerator generator = this.getGenerators().get(keyField.getType());
            if (generator == null) continue;
            String idString = generator.nextId(entityName);
            UtilBeans.setProperty((Object)entity, (String)keyField.getFieldName(), (Object)idString);
            fields.put(keyField.getFieldName(), idString);
        }
    }

    private boolean isLogicalDeletable(String entityName) throws EntityException {
        return ModelEntityUtil.getModelEntity(entityName).isLogiclyDeletable();
    }

    @Override
    public <T> T findOne(String entityName, EntityCondition EntityCondition2, Class<T> clazz) throws EntityException {
        try {
            EntitySelectScript script = new EntitySelectScript(entityName);
            script.selectAllField();
            script.setWhereCondition(EntityCondition2);
            return this.onlyOne(this.scriptExecutor.query(script, clazz));
        }
        catch (Exception e) {
            throw EntityException.getInstance(e);
        }
    }

    @Override
    public void update(String entityName, Map<String, Object> fieldsToSet, EntityCondition condition) throws EntityException {
        EntityUpdateScript updateScript = new EntityUpdateScript(entityName);
        updateScript.addFields(fieldsToSet);
        updateScript.setWhereCondition(condition);
        this.scriptExecutor.execute(updateScript);
    }

    @Override
    public void remove(String entityName) throws EntityException {
        try {
            EntityCondition condition = EntityCondition.any();
            if (this.isLogicalDeletable(entityName)) {
                Map fieldsToSet = UtilMisc.toMap((String)"deleted", (Object)true);
                this.update(entityName, fieldsToSet, condition);
            } else {
                this.remove(entityName, condition);
            }
        }
        catch (Exception e) {
            throw EntityException.getInstance(e);
        }
    }

    @Override
    public void remove(String entityName, EntityCondition EntityCondition2) throws EntityException {
        if (this.isLogicalDeletable(entityName)) {
            Map fieldsToSet = UtilMisc.toMap((String)"deleted", (Object)true);
            this.update(entityName, fieldsToSet, EntityCondition2);
            return;
        }
        EntityDeleteScript script = new EntityDeleteScript(entityName);
        script.setWhereCondition(EntityCondition2);
        this.scriptExecutor.execute(script);
    }

    @Override
    public <T> List<T> findList(String entityName, QueryArgs queryArgs, Class<T> clazz) throws EntityException {
        EntitySelectScript entityScript = new EntitySelectScript(entityName);
        entityScript.setWhereCondition(queryArgs.whereCondition);
        if (UtilCollection.isEmpty(queryArgs.queryFields)) {
            entityScript.selectAllField();
        } else {
            for (String field : queryArgs.queryFields) {
                entityScript.addSelectedField(field);
            }
        }
        if (UtilCollection.isNotEmpty(queryArgs.orderBy)) {
            for (String field : queryArgs.orderBy) {
                entityScript.addOrderByAsc(field);
            }
        }
        entityScript.setOptions(queryArgs.findOptions);
        return this.scriptExecutor.query(entityScript, clazz);
    }

    @Override
    public long count(String entityName, EntityCondition whereCondition) throws EntityException {
        EntitySelectScript entityScript = new EntitySelectScript(entityName);
        entityScript.setWhereCondition(whereCondition);
        return this.onlyOne(this.scriptExecutor.query(entityScript.countScript(), Long.TYPE));
    }

    @Override
    public long count(EntityScript script) throws EntityException {
        try {
            return this.onlyOne(this.scriptExecutor.query(script, Long.TYPE));
        }
        catch (Exception e) {
            throw EntityException.getInstance(e);
        }
    }

    @Override
    public List<EntityObject> findList(EntityScript script) throws EntityException {
        return (List)UtilMisc.cast(this.scriptExecutor.query(script, EntityObject.class));
    }

    @Override
    public EntityObject findOne(String entityName, QueryArgs queryArgs) throws EntityException {
        return this.onlyOne(this.findList(entityName, queryArgs));
    }

    @Override
    public <T> T findOne(String entityName, QueryArgs queryArgs, Class<T> clazz) throws EntityException {
        return this.onlyOne(this.findList(entityName, queryArgs, clazz));
    }

    @Override
    public <T> T findOne(EntityScript script, Class<T> clazz) throws EntityException {
        return (T)UtilMisc.cast(this.onlyOne(this.scriptExecutor.query(script, clazz)));
    }

    @Override
    public <T> List<T> findList(EntityScript script, Class<T> clazz) throws EntityException {
        return (List)UtilMisc.cast(this.scriptExecutor.query(script, clazz));
    }

    @Override
    public EntityObject findOne(String entityName, EntityCondition entityCondition) throws EntityException {
        return this.findOne(entityName, entityCondition, EntityObject.class);
    }

    @Override
    public List<EntityObject> findList(String entityName, QueryArgs queryArgs) throws EntityException {
        return this.findList(entityName, queryArgs, EntityObject.class);
    }

    @Override
    public <T> List<T> findList(String entityName, EntityCondition whereCondition, Class<T> clazz) throws EntityException {
        EntitySelectScript script = new EntitySelectScript(entityName);
        script.selectAllField();
        script.setWhereCondition(whereCondition);
        return this.findList(script, clazz);
    }

    @Override
    public List<EntityObject> findList(String entityName, EntityCondition whereCondition) throws EntityException {
        EntitySelectScript script = new EntitySelectScript(entityName);
        script.selectAllField();
        script.setWhereCondition(whereCondition);
        return this.findList(script);
    }

    @Override
    public EntityObject findOne(EntityScript script) throws EntityException {
        return this.findOne(script, EntityObject.class);
    }

    private <T> T onlyOne(List<T> list) {
        if (UtilCollection.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new EntityException("un unique");
        }
        return (T)UtilCollection.first(list);
    }
}

