/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.util;

import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.EntityObject;
import com.sprite.framework.entity.util.EntityGroup;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilXml;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityDataReader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<EntityGroup> loadToEntity(Document document) {
        if (document == null) {
            return Collections.emptyList();
        }
        Element docElement = document.getDocumentElement();
        if (!"entity-data".equals(docElement.getTagName())) {
            throw new IllegalArgumentException("entity data resource error");
        }
        return this.loadToEntity(docElement);
    }

    public List<EntityGroup> loadToEntity(Element docElement) {
        docElement.normalize();
        Node curChild = docElement.getFirstChild();
        LinkedList<EntityGroup> entities = new LinkedList<EntityGroup>();
        if (curChild != null) {
            EntityGroup defaultGroup = new EntityGroup();
            entities.add(defaultGroup);
            do {
                if (curChild.getNodeType() != 1) continue;
                Element element = (Element)curChild;
                String nodeName = curChild.getNodeName();
                if ("entity-group".equals(nodeName)) {
                    List<EntityGroup> list = this.loadToEntity(element);
                    entities.addAll(list);
                    continue;
                }
                if (!"entity".equals(nodeName)) continue;
                EntityObject value = null;
                try {
                    value = this.toEntity(element);
                }
                catch (EntityException e) {
                    this.logger.error("Transfer entity data to Entity", (Throwable)((Object)e));
                }
                if (value == null) continue;
                defaultGroup.addEntity(value);
            } while ((curChild = curChild.getNextSibling()) != null);
        }
        return entities;
    }

    public EntityObject toEntity(Element element) throws EntityException {
        if (element == null) {
            return null;
        }
        List fields = UtilXml.childElementList((Element)element, (String)"field");
        if (UtilCollection.isEmpty((Collection)fields)) {
            return null;
        }
        EntityObject entityObject = new EntityObject();
        entityObject.setEntityName(element.getAttribute("entityName"));
        for (Element field : fields) {
            entityObject.put(field.getAttribute("name"), field.getAttribute("value"));
        }
        return entityObject;
    }
}

