/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.script;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityCondition;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.EntityFindOptions;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.condition.EmptyCondition;
import com.sprite.framework.entity.condition.MultiOperateValue;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelEntityView;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.script.EntityAlias;
import com.sprite.framework.entity.script.EntityFieldAlias;
import com.sprite.framework.entity.script.EntityFieldAliasBuilder;
import com.sprite.framework.entity.script.EntityScriptFunction;
import com.sprite.framework.entity.script.EntityViewLink;
import com.sprite.utils.UtilArray;
import com.sprite.utils.UtilString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EntityView
implements MultiOperateValue,
EntityFieldAliasBuilder,
EntityScript,
ModelEntityView {
    private List<EntityFieldAlias> viewFields = new LinkedList<EntityFieldAlias>();
    private List<EntityFieldAlias> groupByFields = new ArrayList<EntityFieldAlias>();
    private List<EntityAlias> memberEntities = new LinkedList<EntityAlias>();
    private List<EntityViewLink> links = new LinkedList<EntityViewLink>();
    private boolean distinct = false;
    private EntityCondition whereCondition;
    private EntityCondition havingCondition;
    private List<EntityFieldAlias> orderByFields = new ArrayList<EntityFieldAlias>();
    private EntityFindOptions options;
    private Map<String, EntityAlias> entityMap = new HashMap<String, EntityAlias>();
    private Map<String, EntityViewLink> linkMap = new HashMap<String, EntityViewLink>();
    private Map<String, EntityFieldAlias> fieldMap = new HashMap<String, EntityFieldAlias>();

    public EntityView() {
    }

    public EntityView(String entityName, String entityAlias) {
        this.addMemberEntity(entityName, entityAlias);
    }

    public void addMemberEntity(String entityName, String entityAlias) {
        if (entityName == null) {
            throw new IllegalArgumentException("entityAlias  must");
        }
        if (entityAlias == null) {
            throw new IllegalArgumentException("entity must");
        }
        if (this.entityMap.containsKey(entityAlias)) {
            throw new IllegalArgumentException("EntityAlias [" + entityAlias + "] is exist");
        }
        EntityAlias alias = new EntityAlias(entityName, entityAlias);
        this.entityMap.put(entityAlias, alias);
        this.memberEntities.add(alias);
    }

    public void leftJoin(EntityView entityView, String alias, EntityCondition condition) {
        this.join("LEFT JOIN", entityView, alias, condition);
    }

    public void leftJoin(String entityName, String alias, EntityCondition condition) {
        this.join("LEFT JOIN", entityName, alias, condition);
    }

    public void innerJoin(EntityView entityView, String alias, EntityCondition condition) {
        this.join("INNER JOIN", entityView, alias, condition);
    }

    public void innerJoin(String entityName, String alias, EntityCondition condition) {
        this.join("LEFT JOIN", entityName, alias, condition);
    }

    private void join(String code, EntityView entityView, String alias, EntityCondition condition) {
        if (UtilString.isBlank((CharSequence)alias)) {
            throw new IllegalArgumentException("alias must ");
        }
        if (this.linkMap.containsKey(alias)) {
            throw new IllegalArgumentException("EntityView [" + alias + "] is joined ");
        }
        EntityViewLink link = new EntityViewLink(code, entityView, alias, condition);
        this.links.add(link);
        this.linkMap.put(alias, link);
    }

    private void join(String code, String entityName, String alias, EntityCondition condition) {
        if (UtilString.isBlank((CharSequence)alias)) {
            throw new IllegalArgumentException("alias must ");
        }
        if (this.linkMap.containsKey(alias)) {
            throw new IllegalArgumentException("EntityView [" + alias + "] is joined ");
        }
        EntityViewLink link = new EntityViewLink(code, entityName, alias, condition);
        this.links.add(link);
        this.linkMap.put(alias, link);
    }

    private void addField(String entityAlias, String field, String fieldAlias, EntityScriptFunction function) {
        EntityFieldAlias alias = this.getEntityFieldAliasBuilder(entityAlias).buildFieldAlias(field, fieldAlias, function);
        alias.setEntityAlias(entityAlias);
        if (alias.getFieldAlias() == null) {
            alias.setFieldAlias(field);
        }
        this.viewFields.add(alias);
        this.fieldMap.put(alias.getFieldAlias(), alias);
    }

    public void addViewFieldAs(String entityAlias, String field, String fieldAlias, EntityScriptFunction function) {
        if (UtilString.isBlank((CharSequence)fieldAlias)) {
            throw new IllegalArgumentException("fieldAlias must, if you not provide alias ,to see addViewField ");
        }
        this.addField(entityAlias, field, fieldAlias, function);
    }

    public void addViewFieldAs(String entityAlias, String ... fields) {
        if (UtilArray.isEmpty((Object[])fields) || fields.length % 2 != 0) {
            throw new IllegalArgumentException("fields expect a value and length is multiple of 2 ");
        }
        for (int i = 0; i <= fields.length - 2; i += 2) {
            this.addField(entityAlias, fields[i], fields[i + 1], null);
        }
    }

    public void addViewField(String entityAlias, String field, EntityScriptFunction function) {
        this.addField(entityAlias, field, field, function);
    }

    public void addViewField(String entityAlias, String ... fields) {
        if (!UtilArray.isEmpty((Object[])fields)) {
            for (String field : fields) {
                this.addField(entityAlias, field, field, null);
            }
        } else {
            this.addAllField(entityAlias);
        }
    }

    private void addAllField(String entityAlias) {
        List<EntityFieldAlias> aliasList = this.getEntityFieldAliasBuilder(entityAlias).buildAllFieldAlias();
        for (EntityFieldAlias alias : aliasList) {
            alias.setEntityAlias(entityAlias);
            if (alias.getFieldAlias() == null) {
                alias.setFieldAlias(alias.getFieldName());
            }
            this.viewFields.add(alias);
            this.fieldMap.put(alias.getFieldAlias(), alias);
        }
    }

    public void addGroupByField(String entityAlias, String ... fields) {
        if (UtilArray.isEmpty((Object[])fields)) {
            return;
        }
        for (String field : fields) {
            EntityFieldAlias alias = this.getEntityFieldAliasBuilder(entityAlias).buildFieldAlias(field, null, null);
            alias.setEntityAlias(entityAlias);
            this.groupByFields.add(alias);
        }
    }

    public void addOrderByDesc(String entityAlias, String ... fields) {
        if (UtilArray.isEmpty((Object[])fields)) {
            return;
        }
        for (String field : fields) {
            EntityFieldAlias alias = this.getEntityFieldAliasBuilder(entityAlias).buildFieldAlias(field, null, null);
            alias.setEntityAlias(entityAlias);
            this.orderByFields.add(alias);
        }
    }

    public void addOrderByAsc(String entityAlias, String ... fields) {
        if (UtilArray.isEmpty((Object[])fields)) {
            return;
        }
        for (String field : fields) {
            EntityFieldAlias alias = this.getEntityFieldAliasBuilder(entityAlias).buildFieldAlias(field, null, null);
            alias.setEntityAlias(entityAlias);
            alias.setIsASC();
            this.orderByFields.add(alias);
        }
    }

    public EntityScript countScript() {
        DataScriptStatement statement = new DataScriptStatement();
        statement.append("SELECT");
        statement.append(" COUNT(*) ");
        this.makeFromFragment(statement, this);
        if (this.whereCondition != null && !EmptyCondition.class.isInstance(this.whereCondition)) {
            statement.append(" WHERE ");
            this.whereCondition.makeScript(statement, this);
        }
        this.makeGroupByFragment(statement, this);
        if (this.havingCondition != null) {
            statement.append(" HAVING ");
            this.havingCondition.makeScript(statement, this);
        }
        this.makeOrderByFragment(statement, this);
        this.makeOffset(statement, this);
        return statement;
    }

    public EntityScript count(String entityAlias, String field) {
        EntityView countView = new EntityView();
        countView.distinct = this.distinct;
        countView.memberEntities = this.memberEntities;
        countView.groupByFields = this.groupByFields;
        countView.memberEntities = this.memberEntities;
        countView.links = this.links;
        countView.addViewFieldAs(entityAlias, field, null, EntityScriptFunction.COUNT);
        countView.whereCondition = this.whereCondition;
        return countView;
    }

    public void makeStatement(DataScriptStatement statement) throws EntityException {
        this.makeStatement(statement, this);
    }

    @Override
    public void makeStatement(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        this.makeSelectFragment(statement, modelViewEntity);
        this.makeFromFragment(statement, modelViewEntity);
        if (this.whereCondition != null && !EmptyCondition.class.isInstance(this.whereCondition)) {
            if (this.viewFields != null && !this.viewFields.isEmpty()) {
                statement.append(" WHERE");
            }
            this.whereCondition.makeScript(statement, modelViewEntity);
        }
        this.makeGroupByFragment(statement, modelViewEntity);
        if (this.havingCondition != null) {
            statement.append(" HAVING ");
            this.havingCondition.makeScript(statement, modelViewEntity);
        }
        this.makeOrderByFragment(statement, modelViewEntity);
        this.makeOffset(statement, modelViewEntity);
    }

    private void makeSelectFragment(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        if (this.viewFields == null || this.viewFields.isEmpty()) {
            return;
        }
        statement.append("SELECT");
        if (this.distinct) {
            statement.append(" DISTINCT ");
        }
        int length = this.viewFields.size();
        for (EntityFieldAlias fieldAlias : this.viewFields) {
            --length;
            statement.append(" ");
            if (modelViewEntity != null) {
                statement.append(fieldAlias.function(modelViewEntity.resolveFieldPath(fieldAlias.getFieldPath())));
                if (fieldAlias.getFieldAlias() != null) {
                    statement.append(" AS ").append(fieldAlias.getFieldAlias());
                }
            } else if (fieldAlias.getFunction() != null) {
                statement.append(fieldAlias.function(fieldAlias.getFieldName()));
                if (fieldAlias.getFieldAlias() != null) {
                    statement.append(" ").append(fieldAlias.getFieldAlias());
                }
            } else {
                statement.append(" ").append(fieldAlias.getEntityAlias()).append(".").append(fieldAlias.getFieldName());
                if (fieldAlias.getFieldAlias() != null) {
                    statement.append(" AS ").append(fieldAlias.getFieldAlias());
                }
            }
            if (length <= 0) continue;
            statement.append(",");
        }
    }

    private void makeFromFragment(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        if (this.memberEntities.isEmpty() && this.links.isEmpty()) {
            return;
        }
        statement.append(" FROM");
        int length = this.memberEntities.size();
        for (EntityAlias entry : this.memberEntities) {
            --length;
            statement.append(" ");
            statement.append(ModelEntityUtil.getModelEntity(entry.getEntityName()).getTableName());
            statement.append(" AS ").append(entry.getEntityAlias());
            if (length <= 0) continue;
            statement.append(",");
        }
        for (EntityViewLink link : this.links) {
            statement.append(" ");
            statement.append(link.code);
            link.makeStatement(statement, modelViewEntity);
            statement.append(" ON ");
            link.onCondition.makeScript(statement, modelViewEntity);
        }
    }

    private void makeGroupByFragment(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        int length = this.groupByFields.size();
        boolean hasGroupBy = false;
        for (EntityFieldAlias fieldAlias : this.groupByFields) {
            --length;
            if (!hasGroupBy) {
                statement.append(" GROUP BY");
                hasGroupBy = true;
            }
            statement.append(" ");
            if (modelViewEntity != null) {
                statement.append(modelViewEntity.resolveFieldPath(fieldAlias.getFieldPath()));
            } else {
                String entityAlias = fieldAlias.getEntityAlias();
                String field = fieldAlias.getFieldName();
                String prefix = entityAlias + ".";
                statement.append(prefix).append(field);
            }
            if (length <= 0) continue;
            statement.append(",");
        }
    }

    private void makeOffset(DataScriptStatement statement, ModelEntityView modelViewEntity) {
        if (this.options == null) {
            return;
        }
        if (ModelEntityUtil.DATABASE_TYPE_MYSQL.equals(ModelEntityUtil.getDatabaseType())) {
            statement.append(" LIMIT ").append(this.options.getOffset() + ",").append(this.options.getLimit() + "");
            return;
        }
        if (ModelEntityUtil.DATABASE_TYPE_SQLSERVER2012.equals(ModelEntityUtil.getDatabaseType())) {
            statement.append(" OFFSET ").append(this.options.getOffset() + " ROW FETCH NEXT ").append(this.options.getLimit() + " ROWS only");
            return;
        }
        if (ModelEntityUtil.DATABASE_TYPE_PGSQL.equals(ModelEntityUtil.getDatabaseType())) {
            statement.append(" LIMIT ").append(this.options.getLimit() + " OFFSET ").append(this.options.getOffset() + " ");
            return;
        }
        DataScriptStatement scriptStatement = new DataScriptStatement();
        scriptStatement.addParams(statement.getParams());
        if (ModelEntityUtil.DATABASE_TYPE_SQLSERVER.equals(ModelEntityUtil.getDatabaseType())) {
            String temp = "SELECT TOP {} _rn.* from (SELECT row_number() over({}) as _rnum,* from({}) as _rf) as _rn WHERE _rnum>{}";
            temp = UtilString.place((String)temp, (Object[])new Object[]{this.options.getOffset(), this.makeOrderByFragment(modelViewEntity), scriptStatement.toScriptString(), this.options.getOffset()});
            scriptStatement.append(temp);
        } else if (ModelEntityUtil.DATABASE_TYPE_ORACLE.equals(ModelEntityUtil.getDatabaseType())) {
            String temp = "SELECT * FROM(SELECT a.*,ROWNUM _rnum FROM({}) _rn WHERE ROWNUM<=({})) WHERE _rnum>{}";
            temp = UtilString.place((String)temp, (Object[])new Object[]{scriptStatement.toScriptString(), this.options.getOffset() + this.options.getLimit(), this.options.getOffset()});
        }
        statement.clear();
        statement.append(scriptStatement.toScriptString());
        statement.addParams(scriptStatement.getParams());
    }

    private void makeOrderByFragment(DataScriptStatement statement, ModelEntityView modelViewEntity) {
        statement.append(this.makeOrderByFragment(modelViewEntity));
    }

    private String makeOrderByFragment(ModelEntityView modelViewEntity) {
        StringBuilder orderStr = new StringBuilder();
        int length = this.orderByFields.size();
        boolean has = false;
        for (EntityFieldAlias fieldAlias : this.orderByFields) {
            String order;
            --length;
            boolean asc = Boolean.TRUE.equals(fieldAlias.getIsASC());
            String string = order = asc ? "ASC" : "DESC";
            if (!has) {
                orderStr.append(" ORDER BY ");
                has = true;
            }
            orderStr.append(" ");
            if (modelViewEntity != null) {
                orderStr.append(modelViewEntity.resolveFieldPath(fieldAlias.getFieldPath()));
            } else {
                String entityAlias = fieldAlias.getEntityAlias();
                String field = fieldAlias.getFieldName();
                String prefix = entityAlias + ".";
                orderStr.append(prefix).append(field);
            }
            orderStr.append(" ").append(order);
            if (length <= 0) continue;
            orderStr.append(",");
        }
        return orderStr.toString();
    }

    private void checkEntityAlias(String entityAlias) {
        if (!this.entityMap.containsKey(entityAlias) && !this.linkMap.containsKey(entityAlias)) {
            throw new IllegalArgumentException("EntityAlias [" + entityAlias + "] is not exist");
        }
    }

    private EntityFieldAliasBuilder getEntityFieldAliasBuilder(String entityAlias) {
        this.checkEntityAlias(entityAlias);
        if (this.entityMap.get(entityAlias) != null) {
            return this.entityMap.get(entityAlias);
        }
        return this.linkMap.get(entityAlias);
    }

    public void distinct() {
        this.distinct = true;
    }

    public void setWhereCondition(EntityCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public void setHavingCondition(EntityCondition havingCondition) {
        this.havingCondition = havingCondition;
    }

    public void setOptions(EntityFindOptions options) {
        this.options = options;
    }

    @Override
    public EntityFieldAlias buildFieldAlias(String fieldName, String fieldAlias, EntityScriptFunction function) {
        EntityFieldAlias alias = this.fieldMap.get(fieldName);
        EntityFieldAlias fiAlias = new EntityFieldAlias(null, fieldName, fieldAlias, function, null);
        ModelField modelField = new ModelField(fieldName, alias.getFieldAlias(), null);
        fiAlias.setModelField(modelField);
        return fiAlias;
    }

    @Override
    public List<EntityFieldAlias> buildAllFieldAlias() {
        LinkedList<EntityFieldAlias> list = new LinkedList<EntityFieldAlias>();
        for (EntityFieldAlias fieldAlias : this.viewFields) {
            list.add(this.buildFieldAlias(fieldAlias.getFieldAlias(), fieldAlias.getFieldAlias(), null));
        }
        return list;
    }

    @Override
    public DataScriptStatement getStatement() {
        DataScriptStatement statement = new DataScriptStatement();
        this.makeStatement(statement, this);
        return statement;
    }

    @Override
    public boolean hasField(String field) {
        for (EntityFieldAlias fieldAlias : this.viewFields) {
            if (!fieldAlias.getFieldName().equalsIgnoreCase(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String resolveFieldPath(String path) throws EntityException {
        String entityAlias = null;
        String field = path;
        int i = path.lastIndexOf(".");
        if (i > 0) {
            entityAlias = path.substring(0, i);
            field = path.substring(i + 1);
        }
        if (entityAlias == null) {
            EntityAlias ev = null;
            for (EntityAlias entity : this.memberEntities) {
                if (!entity.hasField(field)) continue;
                if (ev == null) {
                    ev = entity;
                    continue;
                }
                throw new EntityException("must point entityAlis for field");
            }
            if (ev == null) {
                throw new EntityException(String.format("[%s] field not exist", path));
            }
            return ev.resolveFieldPath(field);
        }
        return this.resolveField(entityAlias, field);
    }

    private String resolveField(String entityAlias, String field) {
        EntityFieldAliasBuilder modelEntity = this.entityMap.get(entityAlias);
        if (modelEntity == null) {
            modelEntity = this.linkMap.get(entityAlias);
        }
        if (modelEntity == null) {
            throw new EntityException("ModelField  [" + entityAlias + "] is not exist");
        }
        String column = modelEntity.resolveFieldPath(field);
        return String.format("%s.%s", entityAlias, column);
    }
}

