/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.model;

import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.model.ModelFieldType;
import com.sprite.utils.cache.UtilCache;
import java.util.Collection;
import java.util.List;

public final class ModelEntityUtil {
    public static String DATABASE_TYPE_SQLSERVER = "sqlserver";
    public static String DATABASE_TYPE_SQLSERVER2012 = "sqlserver2012";
    public static String DATABASE_TYPE_MYSQL = "mysql";
    public static String DATABASE_TYPE_ORACLE = "oracle";
    public static String DATABASE_TYPE_PGSQL = "pgsql";
    private static UtilCache<ModelEntity> persistentClasses = UtilCache.createUtilCache((String)"cache.persistentClasses");
    private static ModelEntity sequenceEntity = new ModelEntity();
    private static String databaseType;
    private static UtilCache<ModelFieldType> modelFieldTypes;

    protected static void addModelEntities(Collection<ModelEntity> modelEntities) {
        if (modelEntities == null) {
            return;
        }
        for (ModelEntity modelEntity : modelEntities) {
            String entityName = modelEntity.getEntityName();
            if (persistentClasses.putIfAbsent(entityName, (Object)modelEntity) == null) continue;
            throw new EntityException("EntityModel has existed [" + entityName + "]");
        }
    }

    protected static void addModelEntity(ModelEntity modelEntity) {
        if (modelEntity == null) {
            return;
        }
        if (persistentClasses.putIfAbsent(modelEntity.getEntityName(), (Object)modelEntity) != null) {
            throw new EntityException("EntityModel has existed [" + modelEntity.getEntityName() + "]");
        }
    }

    protected static void addModelFieldType(Collection<ModelFieldType> fieldTypes) {
        if (fieldTypes == null) {
            return;
        }
        for (ModelFieldType modelEntity : fieldTypes) {
            String type = modelEntity.getType();
            if (modelFieldTypes.putIfAbsent(type, (Object)modelEntity) == null) continue;
            throw new EntityException("ModelFieldType has existed [" + type + "]");
        }
    }

    protected static void addModelFieldType(ModelFieldType fieldType) {
        String type = fieldType.getType();
        if (modelFieldTypes.putIfAbsent(type, (Object)fieldType) != null) {
            throw new EntityException("ModelFieldType has existed [" + type + "]");
        }
    }

    protected static void setDatabaseType(String type) {
        databaseType = type;
    }

    public static String getDatabaseType() {
        return databaseType;
    }

    public static ModelFieldType getFieldType(String type) {
        ModelFieldType fieldType = (ModelFieldType)modelFieldTypes.get(type);
        if (fieldType == null) {
            throw new EntityException("not found ModelFieldType by [" + type + "]");
        }
        return fieldType;
    }

    public static ModelEntity getModelEntity(String entityName) throws EntityException {
        ModelEntity modelEntity = (ModelEntity)persistentClasses.get(entityName);
        if (modelEntity == null) {
            throw new EntityException("not found EntityModel by [" + entityName + "]");
        }
        return modelEntity;
    }

    public static List<ModelEntity> getModelEntityList() {
        return persistentClasses.values();
    }

    static {
        sequenceEntity.setEntityName("SequenceItem");
        sequenceEntity.addModelField(new ModelField("id", "id", "str-short"));
        sequenceEntity.addModelField(new ModelField("sequenceValue", "sequence_value", "int-long"));
        modelFieldTypes = UtilCache.createUtilCache((String)"_modelFeildType_");
    }
}

