/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.model;

import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.model.ModelEntityView;
import com.sprite.framework.entity.model.ModelField;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ModelEntity
implements ModelEntityView {
    private String entityName;
    private String tableName;
    private String entitySingleName;
    private String packageName;
    private Map<String, ModelField> fields = new LinkedHashMap<String, ModelField>();
    private List<ModelField> keys = new LinkedList<ModelField>();

    public ModelField getModelField(String fieldName) throws EntityException {
        ModelField field = this.fields.get(fieldName);
        if (field == null) {
            throw new EntityException("not find field[" + fieldName + "] in entity [" + this.entityName + "]");
        }
        return field;
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fields.get(fieldName) != null;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntitySingleName() {
        return this.entitySingleName;
    }

    public void setEntitySingleName(String entitySingleName) {
        this.entitySingleName = entitySingleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public List<ModelField> getFields() {
        return new LinkedList<ModelField>(this.fields.values());
    }

    public List<ModelField> getKeys() {
        return this.keys;
    }

    public ModelField getFieldByColumnName(String columnName) {
        for (ModelField modelField : this.fields.values()) {
            if (!modelField.getFieldName().equalsIgnoreCase(columnName)) continue;
            return modelField;
        }
        return null;
    }

    public void addModelField(ModelField modelField) {
        this.fields.put(modelField.getFieldName(), modelField);
        if (modelField.isKey()) {
            this.keys.add(modelField);
        }
    }

    public void setModelFields(List<ModelField> fields) {
        if (fields == null) {
            return;
        }
        for (ModelField modelField : fields) {
            this.fields.put(modelField.getFieldName(), modelField);
        }
    }

    public void extend(ModelEntity modelEntity) {
        this.keys.addAll(modelEntity.getKeys());
        this.fields.putAll(modelEntity.fields);
    }

    public boolean isLogiclyDeletable() {
        return this.hasField("deleted");
    }

    @Override
    public String resolveFieldPath(String fieldPath) {
        return this.getModelField(fieldPath).getColName();
    }
}

