/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.mapper.reolver.node;

import com.sprite.framework.entity.mapper.reolver.DynamicContext;
import com.sprite.framework.entity.mapper.reolver.SqlNode;
import com.sprite.utils.UtilString;
import java.util.List;
import java.util.Map;

public class TrimSqlNode
implements SqlNode {
    private String prefix;
    private String prefixOverride;
    private String suffix;
    private String suffixOverride;
    private SqlNode content;

    @Override
    public boolean apply(DynamicContext context) {
        List list;
        DynamicContextProxy proxy = new DynamicContextProxy(context);
        boolean isApply = this.content.apply(proxy);
        if (!isApply) {
            return false;
        }
        context.append(this.prefix);
        String sql = proxy.toSql().trim();
        if (this.prefixOverride != null) {
            list = UtilString.tokenizeToStringList((String)this.prefixOverride, (String)"|");
            for (String override : list) {
                if (!sql.startsWith(override = override.trim())) continue;
                sql = sql.substring(override.length()).trim();
            }
        }
        if (this.suffixOverride != null) {
            list = UtilString.tokenizeToStringList((String)this.suffixOverride, (String)"|");
            for (String override : list) {
                if (!sql.endsWith(override = override.trim())) continue;
                sql = sql.substring(0, sql.length() - override.length()).trim();
            }
        }
        context.append(sql);
        context.addParams(proxy.getParams());
        if (isApply) {
            context.append(this.suffix);
        }
        return false;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefixOverride() {
        return this.prefixOverride;
    }

    public void setPrefixOverride(String prefixOverride) {
        this.prefixOverride = prefixOverride;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffixOverride() {
        return this.suffixOverride;
    }

    public void setSuffixOverride(String suffixOverride) {
        this.suffixOverride = suffixOverride;
    }

    public SqlNode getContent() {
        return this.content;
    }

    public void setContent(SqlNode content) {
        this.content = content;
    }

    static class DynamicContextProxy
    extends DynamicContext {
        private DynamicContext orginal;

        public DynamicContextProxy(DynamicContext context) {
            super(null);
            this.orginal = context;
            this.setNamespace(context.getNamespace());
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.orginal.getBindings();
        }

        @Override
        public void bind(String key, Object value) {
            this.orginal.bind(key, value);
        }
    }
}

