/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.mapper.reolver;

import com.sprite.framework.entity.mapper.MapperException;
import com.sprite.framework.entity.mapper.StatementMapper;
import com.sprite.framework.entity.mapper.reolver.Parser;
import com.sprite.framework.entity.mapper.reolver.SqlNode;
import com.sprite.framework.entity.mapper.reolver.node.MixedSqlNode;
import com.sprite.utils.UtilString;
import com.sprite.utils.UtilXml;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class StatementResolver {
    public static StatementMapper reolve(Element element, String namespace) {
        String tag = element.getTagName();
        if (!("select".equals(tag) || "insert".equals(tag) || "update".equals(tag) || "fragment".equals(tag))) {
            throw new MapperException("unsupprot tag :" + tag);
        }
        String statementId = namespace + "." + element.getAttribute("id");
        if (UtilString.isBlank((CharSequence)statementId)) {
            throw new MapperException("statement not has id");
        }
        SqlNode rootNode = null;
        List sqlNodes = UtilXml.childNodeList((Element)element);
        if (sqlNodes.size() == 1) {
            rootNode = Parser.parser((Node)sqlNodes.get(0));
        } else {
            MixedSqlNode mixedSqlNode = new MixedSqlNode();
            for (Node el : sqlNodes) {
                SqlNode node = Parser.parser(el);
                if (node == null) continue;
                mixedSqlNode.append(node);
            }
            rootNode = mixedSqlNode;
        }
        return new StatementMapper(rootNode, statementId, namespace);
    }
}

