/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.idgenerator;

import com.sprite.framework.entity.Delegator;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.IdGenerator;
import com.sprite.framework.entity.util.SequenceUtil;
import com.sprite.utils.cache.UtilCache;

public class SequenceGenerator
implements IdGenerator {
    private UtilCache<SequenceUtil> sequenceCached = UtilCache.createUtilCache((String)"cache.SequenceUtil");
    private EntityScriptExecutor scriptExecutor;
    private Delegator delegator;

    public SequenceGenerator(EntityScriptExecutor scriptExecutor, Delegator delegator) {
        this.scriptExecutor = scriptExecutor;
        this.delegator = delegator;
    }

    @Override
    public String name() {
        return "sequence";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nextId(String entityName) {
        SequenceUtil sequenceUtil = (SequenceUtil)this.sequenceCached.get(entityName);
        if (sequenceUtil == null) {
            UtilCache<SequenceUtil> utilCache = this.sequenceCached;
            synchronized (utilCache) {
                if (sequenceUtil == null) {
                    sequenceUtil = new SequenceUtil(entityName, 1000L, 100L, this.scriptExecutor, this.delegator);
                    this.sequenceCached.put(entityName, (Object)sequenceUtil);
                }
            }
        }
        return sequenceUtil.nextValue() + "";
    }

    public EntityScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(EntityScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public Delegator getDelegator() {
        return this.delegator;
    }

    public void setDelegator(Delegator delegator) {
        this.delegator = delegator;
    }
}

