/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.condition;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.condition.CollectionEntityComparisonOperator;
import com.sprite.framework.entity.condition.CollectionOperateValue;
import com.sprite.framework.entity.condition.EntityComparisonOperator;
import com.sprite.framework.entity.condition.EntityJoinOperator;
import com.sprite.framework.entity.condition.MultiOperateValue;
import com.sprite.framework.entity.condition.NoParameterized;
import com.sprite.framework.entity.model.ModelEntityView;
import com.sprite.framework.entity.script.EntityView;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilMisc;
import java.util.Collection;

public abstract class EntityOperator<L, R, T> {
    public static final int ID_EQUALS = 1;
    public static final int ID_NOT_EQUAL = 2;
    public static final int ID_LESS_THAN = 3;
    public static final int ID_GREATER_THAN = 4;
    public static final int ID_LESS_THAN_EQUAL_TO = 5;
    public static final int ID_GREATER_THAN_EQUAL_TO = 6;
    public static final int ID_IN = 7;
    public static final int ID_BETWEEN = 8;
    public static final int ID_NOT = 9;
    public static final int ID_AND = 10;
    public static final int ID_OR = 11;
    public static final int ID_LIKE = 12;
    public static final int ID_NOT_IN = 13;
    public static final int ID_NOT_LIKE = 14;
    public static final int ID_IS_NULL = 15;
    public static final int ID_NOT_NULL = 16;
    private int idInt;
    private String codeString;
    public static final EntityComparisonOperator<?, ?> EQUALS = new EntityComparisonOperator<Object, Object>(1, "="){};
    public static final EntityComparisonOperator<?, ?> NOT_EQUALS = new EntityComparisonOperator<Object, Object>(2, "!="){};
    public static final EntityComparisonOperator<?, ?> LESS_THAN = new EntityComparisonOperator<Object, Object>(3, "<"){};
    public static final EntityComparisonOperator<?, ?> GREATER_THAN = new EntityComparisonOperator<Object, Object>(4, ">"){};
    public static final EntityComparisonOperator<?, ?> LESS_THAN_EQUAL_TO = new EntityComparisonOperator<Object, Object>(5, "<="){};
    public static final EntityComparisonOperator<?, ?> GREATER_THAN_EQUAL_TO = new EntityComparisonOperator<Object, Object>(6, ">="){};
    public static final EntityComparisonOperator<?, ?> NOT = new EntityComparisonOperator<Object, Object>(9, "NOT"){};
    public static final EntityComparisonOperator<?, ?> LIKE = new EntityComparisonOperator<Object, Object>(12, "LIKE"){

        @Override
        public void makeScript(DataScriptStatement script, Object l, Object r, ModelEntityView modelViewEntity) throws EntityException {
            if (r == null) {
                return;
            }
            if (!(r instanceof CharSequence)) {
                throw new EntityException("EntityOption.Link only suport String");
            }
            String val = String.valueOf(r);
            super.makeScript(script, l, "%" + val + "%", modelViewEntity);
        }
    };
    public static final EntityComparisonOperator<?, ?> NOT_LIKE = new EntityComparisonOperator<Object, Object>(14, "NOT LIKE"){};
    public static final EntityComparisonOperator<?, ?> IS_NULL = new EntityComparisonOperator<Object, Object>(15, "IS"){};
    public static final EntityComparisonOperator<?, ?> NOT_NULL = new EntityComparisonOperator<Object, Object>(16, "IS NOT"){};
    public static final CollectionEntityComparisonOperator<?> IN = new CollectionEntityComparisonOperator<MultiOperateValue>(7, "IN"){

        @Override
        public void makeScript(DataScriptStatement script, String l, MultiOperateValue r, ModelEntityView modelViewEntity) throws EntityException {
            if (l == null) {
                throw new IllegalArgumentException("The Operator [IN] must have left");
            }
            script.append(" ");
            String fieldName = l;
            if (modelViewEntity != null) {
                script.append(modelViewEntity.resolveFieldPath(fieldName));
            } else {
                script.append(fieldName);
            }
            script.append(" ");
            script.append(this.getCode());
            script.append("(");
            if (EntityView.class.isInstance(r)) {
                r.makeStatement(script, null);
            } else {
                r.makeStatement(script, modelViewEntity);
            }
            script.append(")");
        }
    };
    public static final CollectionEntityComparisonOperator<?> NOT_IN = new CollectionEntityComparisonOperator<MultiOperateValue>(13, "NOT IN"){

        @Override
        public void makeScript(DataScriptStatement script, String l, MultiOperateValue r, ModelEntityView modelViewEntity) throws EntityException {
            if (l == null) {
                throw new IllegalArgumentException("The Operator [NOT IN] must have left");
            }
            script.append(" ");
            String fieldName = l;
            if (modelViewEntity != null) {
                script.append(modelViewEntity.resolveFieldPath(fieldName));
            } else {
                script.append(fieldName);
            }
            script.append(" ");
            script.append(this.getCode());
            script.append("(");
            r.makeStatement(script, modelViewEntity);
            script.append(")");
        }
    };
    public static final CollectionEntityComparisonOperator<?> BETWEEN = new CollectionEntityComparisonOperator<CollectionOperateValue>(8, "BETWEEN"){

        @Override
        public void makeScript(DataScriptStatement script, String l, CollectionOperateValue v, ModelEntityView modelViewEntity) throws EntityException {
            NoParameterized p;
            if (l == null) {
                throw new IllegalArgumentException("The Operator [BETWEEN] must have left");
            }
            Collection<?> r = v.getValues();
            if (r == null || r.size() != 2) {
                throw new IllegalArgumentException("The Operator [BETWEEN] must have two values");
            }
            script.append(" ");
            String fieldName = l;
            if (modelViewEntity != null) {
                script.append(modelViewEntity.resolveFieldPath(fieldName));
            } else {
                script.append(fieldName);
            }
            script.append(" ");
            script.append(this.getCode());
            Object obj = UtilCollection.at(r, (int)0);
            if (obj instanceof NoParameterized) {
                p = (NoParameterized)obj;
                script.append(p.safeString());
            } else {
                script.append(" ? ");
                script.addParam(obj);
            }
            script.append(" AND ");
            obj = UtilCollection.at(r, (int)1);
            if (obj instanceof NoParameterized) {
                p = (NoParameterized)obj;
                script.append(p.safeString());
            } else {
                script.append(" ? ");
                script.addParam(obj);
            }
        }
    };
    public static final EntityJoinOperator AND = new EntityJoinOperator(10, "AND");
    public static final EntityJoinOperator OR = new EntityJoinOperator(11, "OR");

    protected EntityOperator(int id, String code) {
        this.idInt = id;
        this.codeString = code;
    }

    public String getCode() {
        if (this.codeString == null) {
            return "null";
        }
        return this.codeString;
    }

    public abstract void makeScript(DataScriptStatement var1, L var2, R var3, ModelEntityView var4) throws EntityException;

    public String toString() {
        return this.codeString;
    }

    public int hashCode() {
        return this.codeString.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EntityOperator) {
            EntityOperator otherOper = (EntityOperator)UtilMisc.cast((Object)obj);
            return this.idInt == otherOper.idInt;
        }
        return false;
    }
}

