/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.support;

import cn.weforward.common.sys.GcCleaner;
import cn.weforward.common.util.LruCache;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.ServiceInvokerFactory;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ops.Right;
import cn.weforward.protocol.ops.Role;
import cn.weforward.protocol.ops.User;
import cn.weforward.protocol.ops.UserService;
import cn.weforward.protocol.support.NamingConverter;
import cn.weforward.protocol.support.datatype.FriendlyList;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.StringUtils;

public class MicroserviceUserService
implements UserService {
    protected String m_ApiUrl;
    protected String m_AccessId;
    protected String m_AccessKey;
    protected String m_ServiceName;
    protected String m_MethodGroup;
    protected ServiceInvoker m_Invoker;
    protected LruCache<String, User> m_UserIdCache;
    protected LruCache<String, User> m_AccessIdCache;

    public MicroserviceUserService(String apiUrl, String accessId, String accessKey, String serviceName, String methodGroup) {
        if (StringUtils.isEmpty((Object)serviceName)) {
            throw new NullPointerException("serviceName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.m_ApiUrl = apiUrl;
        this.m_AccessId = accessId;
        this.m_AccessKey = accessKey;
        this.m_ServiceName = serviceName;
        this.m_MethodGroup = NamingConverter.camelToWf((String)StringUtil.toString((Object)methodGroup));
        this.m_UserIdCache = new LruCache("userservice-userid-cache");
        this.m_AccessIdCache = new LruCache("userservice-accessid-cache");
        GcCleaner.register(this.m_UserIdCache);
        GcCleaner.register(this.m_AccessIdCache);
    }

    public User getUser(String id) {
        LruCache<String, User> cache = this.m_UserIdCache;
        User user = (User)cache.get((Object)id);
        if (user == null) {
            ServiceInvoker invoker = this.getInvoker();
            SimpleDtObject params = new SimpleDtObject();
            params.put("id", (DtBase)SimpleDtString.valueOf((String)id));
            Response response = invoker.invoke(this.genMethod("getUser"), (DtObject)params);
            FriendlyObject content = this.getContent(response);
            user = this.getUser(content);
            User old = (User)cache.putIfAbsent((Object)id, (Object)user);
            if (old != null) {
                user = old;
            }
        }
        return user;
    }

    public User getUserByAccess(String accessId) {
        LruCache<String, User> cache = this.m_AccessIdCache;
        User user = (User)cache.get((Object)accessId);
        if (user == null) {
            ServiceInvoker invoker = this.getInvoker();
            SimpleDtObject params = new SimpleDtObject();
            params.put("access_id", (DtBase)SimpleDtString.valueOf((String)accessId));
            Response response = invoker.invoke(this.genMethod("getUserByAccess"), (DtObject)params);
            FriendlyObject content = this.getContent(response);
            user = this.getUser(content);
            User old = (User)cache.putIfAbsent((Object)accessId, (Object)user);
            if (old != null) {
                user = old;
            }
        }
        return user;
    }

    protected ServiceInvoker getInvoker() {
        if (this.m_Invoker == null) {
            this.m_Invoker = ServiceInvokerFactory.create((String)this.m_ServiceName, (String)this.m_ApiUrl, (String)this.m_AccessId, (String)this.m_AccessKey);
        }
        return this.m_Invoker;
    }

    protected String genMethod(String method) {
        return String.valueOf(this.m_MethodGroup) + NamingConverter.camelToWf((String)method);
    }

    protected FriendlyObject getContent(Response response) {
        if (response.getResponseCode() != 0) {
            throw new RuntimeException("\u7f51\u5173\u5f02\u5e38:" + response.getResponseCode() + "/" + response.getResponseMsg());
        }
        FriendlyObject result = FriendlyObject.valueOf((DtObject)response.getServiceResult());
        if (result.getInt("code", -1) != 0) {
            throw new RuntimeException("\u4e1a\u52a1\u5f02\u5e38:" + result.getInt("code", -1) + "/" + result.getString("msg"));
        }
        return result.getFriendlyObject("content");
    }

    protected User getUser(FriendlyObject content) {
        if (content.isNull()) {
            return null;
        }
        SimpleUser user = new SimpleUser(content.getString("id"), content.getString("name"), this.getRight(content.getFriendlyList("right")));
        return user;
    }

    protected List<Right> getRight(FriendlyList list) {
        ArrayList<Right> result = new ArrayList<Right>(list.size());
        int i = 0;
        while (i < list.size()) {
            result.add(this.getRight(list.getFriendlyObject(i)));
            ++i;
        }
        return result;
    }

    protected Right getRight(FriendlyObject object) {
        if (object.isNull()) {
            return null;
        }
        return new SimpleRight((short)object.getInt("rule"), object.getString("uriPattern"));
    }

    protected static class SimpleRight
    implements Right {
        protected short m_Rule;
        protected String m_UriPattern;

        public SimpleRight() {
        }

        public SimpleRight(short rule, String uriPattern) {
            this.m_Rule = rule;
            this.m_UriPattern = uriPattern;
        }

        public short getRule() {
            return this.m_Rule;
        }

        public void setRule(short rule) {
            this.m_Rule = rule;
        }

        public String getUriPattern() {
            return this.m_UriPattern;
        }

        public void setUriPattern(String uri) {
            this.m_UriPattern = uri;
        }

        public String toString() {
            return String.valueOf(this.m_Rule == 128 ? "[x]" : (this.m_Rule == 1 ? "[\u221a]" : "[-]")) + this.m_UriPattern;
        }
    }

    protected static class SimpleUser
    implements User {
        protected String m_Id;
        protected String m_Name;
        protected String m_Password;
        protected List<Right> m_Right;

        public SimpleUser() {
        }

        public SimpleUser(String id, String name, List<Right> right) {
            this.m_Id = id;
            this.m_Name = name;
            this.m_Right = right;
        }

        public String getId() {
            return this.m_Id;
        }

        public void setId(String id) {
            this.m_Id = id;
        }

        public String getName() {
            return this.m_Name;
        }

        public void setName(String name) {
            this.m_Name = name;
        }

        public List<Right> getRight() {
            return this.m_Right;
        }

        public void setRight(List<SimpleRight> right) {
            List<SimpleRight> list = right;
            this.m_Right = list;
        }

        public List<Right> getRights() {
            return this.m_Right;
        }

        public List<Role> getRoles() {
            return Collections.emptyList();
        }

        public String toString() {
            return String.valueOf(this.getId()) + "!" + this.getName();
        }
    }
}

