/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.json.JsonOutput;
import cn.weforward.common.json.JsonOutputStream;
import cn.weforward.common.restful.RestfulRequest;
import cn.weforward.common.restful.RestfulResponse;
import cn.weforward.framework.ext.UriHandler;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.serial.JsonSerialEngine;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.doc.ServiceDocumentVo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

class LocalDocUriHandler
implements UriHandler {
    static final String URI = "/__wf_doc/**";
    Supplier<ServiceDocumentVo> m_Doc;

    LocalDocUriHandler(Supplier<ServiceDocumentVo> doc) {
        this.m_Doc = doc;
    }

    @Override
    public String getUri() {
        return URI;
    }

    @Override
    public void handle(RestfulRequest request, RestfulResponse response) throws IOException {
        ServiceDocumentVo vo = this.m_Doc.get();
        response.setHeader("Content-Type", "application/json;charset=utf-8");
        if (vo == null) {
            response.setStatus(404);
            response.openOutput().close();
        } else {
            response.setStatus(200);
            List<ServiceDocumentVo> vos = Collections.singletonList(vo);
            SimpleDtObject result = new SimpleDtObject();
            result.put("docs", (DtBase)SimpleDtList.toDtList(vos, (ObjectMapper)ServiceDocumentVo.MAPPER));
            Throwable throwable = null;
            Object var7_8 = null;
            try (OutputStream out = response.openOutput();){
                JsonOutputStream jos = new JsonOutputStream(out);
                JsonSerialEngine.formatObject((DtObject)result, (JsonOutput)jos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

