/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.ResultPage;
import cn.weforward.common.util.ClassUtil;
import cn.weforward.common.util.StringUtil;
import cn.weforward.common.util.TransList;
import cn.weforward.framework.ApiMethod;
import cn.weforward.framework.InnerApiMethod;
import cn.weforward.framework.doc.DocMethods;
import cn.weforward.framework.doc.DocObjectProvider;
import cn.weforward.framework.ext.ReflectMethod;
import cn.weforward.framework.ext.WeforwardService;
import cn.weforward.framework.support.AbstractApiMethod;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.StatusCode;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.datatype.DtString;
import cn.weforward.protocol.doc.DocObject;
import cn.weforward.protocol.doc.DocSpecialWord;
import cn.weforward.protocol.doc.annotation.DocAttribute;
import cn.weforward.protocol.doc.annotation.DocMethod;
import cn.weforward.protocol.doc.annotation.DocParameter;
import cn.weforward.protocol.doc.annotation.DocReturn;
import cn.weforward.protocol.doc.annotation.DocService;
import cn.weforward.protocol.ext.ObjectMapper;
import cn.weforward.protocol.support.NamingConverter;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.doc.DocAttributeVo;
import cn.weforward.protocol.support.doc.DocMethodVo;
import cn.weforward.protocol.support.doc.DocModifyVo;
import cn.weforward.protocol.support.doc.DocObjectVo;
import cn.weforward.protocol.support.doc.DocSpecialWordVo;
import cn.weforward.protocol.support.doc.DocStatusCodeVo;
import cn.weforward.protocol.support.doc.ServiceDocumentVo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public class DocumentMethod
extends AbstractApiMethod
implements InnerApiMethod {
    private static final Logger _Logger = LoggerFactory.getLogger(DocumentMethod.class);
    protected WeforwardService m_Service;
    protected ServiceDocumentVo m_Info;
    private static final ConcurrentHashMap<GenericClass, DocObjectVo> OBJECT_MAP = new ConcurrentHashMap();
    private static final Comparator<DocStatusCodeVo> _STATUS_BY_CODE = Comparator.comparingInt(o -> o.code);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DocumentMethod(WeforwardService service) {
        this(service, "");
    }

    public DocumentMethod(WeforwardService service, String basePath) {
        super(String.valueOf(StringUtil.toString((Object)basePath)) + "_doc");
        service.registerMethod(this);
        this.m_Service = service;
    }

    @Override
    public DtBase handle(String path, DtObject params, Request request, Response response) {
        DtString op = params.getString("op");
        if (op != null && StringUtil.eq((String)"clear", (String)op.toString())) {
            this.m_Info = null;
        }
        return ServiceDocumentVo.MAPPER.toDtObject((Object)this.getServiceDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDocumentVo getServiceDocument() {
        if (this.m_Info == null) {
            DocumentMethod documentMethod = this;
            synchronized (documentMethod) {
                this.m_Info = this.init();
            }
        }
        return this.m_Info;
    }

    /*
     * WARNING - void declaration
     */
    private ServiceDocumentVo init() {
        ServiceDocumentVo info = new ServiceDocumentVo();
        info.name = this.m_Service.getName();
        info.version = this.m_Service.getVersion();
        info.description = this.m_Service.getDescription();
        String modifiesPath = this.m_Service.getModifyPath();
        ArrayList objects = new ArrayList(this.m_Service.getObjectClasses());
        for (String packageName : this.m_Service.getObjectPackages()) {
            objects.addAll(ClassUtil.getClasses((String)packageName));
        }
        DocService doc = ClassUtils.getUserClass((Object)this.m_Service).getAnnotation(DocService.class);
        if (doc != null) {
            void var6_15;
            info.name = StringUtil.isEmpty((String)doc.name()) ? info.name : doc.name();
            info.version = StringUtil.isEmpty((String)doc.version()) ? info.version : doc.version();
            info.description = StringUtil.isEmpty((String)doc.description()) ? info.description : doc.description();
            modifiesPath = StringUtil.isEmpty((String)doc.modifyPath()) ? modifiesPath : doc.modifyPath();
            Collections.addAll(objects, doc.objects());
            String[] stringArray = doc.objectPackage();
            int n = stringArray.length;
            boolean bl = false;
            while (var6_15 < n) {
                Object packageName = stringArray[var6_15];
                objects.addAll(ClassUtil.getClasses((String)packageName));
                ++var6_15;
            }
        }
        if (StringUtil.isEmpty((String)modifiesPath)) {
            modifiesPath = String.valueOf(info.name) + ".modify.csv";
        }
        info.modifies = this.toModifies(modifiesPath);
        ArrayList<DocObjectVo> commons = new ArrayList<DocObjectVo>();
        for (Class clazz : objects) {
            commons.add(DocumentMethod.toObject(commons, clazz, null));
        }
        for (DocObject docObject : this.m_Service.getObjects()) {
            commons.add(DocObjectVo.valueOf((DocObject)docObject));
        }
        for (DocObjectProvider docObjectProvider : this.m_Service.getObjectProviders()) {
            commons.add(DocObjectVo.valueOf((DocObject)docObjectProvider.get()));
        }
        ArrayList<DocMethodVo> arrayList = new ArrayList<DocMethodVo>();
        for (Map.Entry entry : this.m_Service.getMethods().entrySet()) {
            ApiMethod method;
            String name = (String)entry.getKey();
            DocMethodVo vo = this.toMethod(commons, name, method = (ApiMethod)entry.getValue());
            if (vo == null) continue;
            arrayList.add(vo);
        }
        Collections.sort(commons);
        info.objects = commons;
        Collections.sort(arrayList);
        info.methods = arrayList;
        ArrayList<DocStatusCodeVo> arrayList2 = new ArrayList<DocStatusCodeVo>();
        if (doc != null) {
            arrayList2.addAll(this.toStatusCodes(doc.statusCodeClass()));
        }
        for (Class<?> clazz : this.m_Service.getStatusCodeClasses()) {
            arrayList2.addAll(this.toStatusCodes(clazz));
        }
        arrayList2.sort(_STATUS_BY_CODE);
        info.statusCodes = arrayList2;
        info.specialWords = new TransList<DocSpecialWordVo, DocSpecialWord>(this.m_Service.getDocSpecialWords()){

            protected DocSpecialWordVo trans(DocSpecialWord src) {
                return new DocSpecialWordVo(src);
            }
        };
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DocModifyVo> toModifies(String path) {
        ArrayList<DocModifyVo> list;
        block17: {
            ClassPathResource res = new ClassPathResource(path);
            if (!res.exists()) {
                return Collections.emptyList();
            }
            list = new ArrayList<DocModifyVo>();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(res.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        String[] arr = line.split(",");
                        DocModifyVo vo = new DocModifyVo();
                        vo.author = arr[0];
                        SimpleDateFormat simpleDateFormat = FORMAT;
                        synchronized (simpleDateFormat) {
                            vo.date = FORMAT.parse(arr[1]);
                        }
                        vo.content = arr[2];
                        list.add(vo);
                    }
                }
                catch (Exception e) {
                    _Logger.warn("\u5ffd\u7565\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
                    if (reader == null) break block17;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        _Logger.warn("\u5ffd\u7565\u5173\u95ed\u5931\u8d25", (Throwable)e2);
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        _Logger.warn("\u5ffd\u7565\u5173\u95ed\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        return list;
    }

    private DocMethodVo toMethod(List<DocObjectVo> commons, String name, ApiMethod method) {
        DocObjectVo detail;
        Class returnClass;
        DocReturn docreturn;
        DocParameter docparameter;
        DocMethod docmethod;
        Method m;
        if (method instanceof InnerApiMethod) {
            return null;
        }
        DocMethodVo vo = new DocMethodVo();
        Class<?> parameterClass = null;
        Map<String, Type> parameterGenericMap = new HashMap<String, Type>();
        Map<String, Type> returnGenericMap = new HashMap<String, Type>();
        int index = 0;
        if (method instanceof ReflectMethod) {
            m = ((ReflectMethod)method).getMethod();
            Class<?> clazz = ((ReflectMethod)method).getMethods();
            DocMethods docMethods = clazz.getAnnotation(DocMethods.class);
            if (docMethods != null) {
                index = docMethods.index();
            }
            docmethod = m.getAnnotation(DocMethod.class);
            docparameter = m.getAnnotation(DocParameter.class);
            docreturn = m.getAnnotation(DocReturn.class);
            Class<?>[] classes = m.getParameterTypes();
            Type[] typeClasses = m.getGenericParameterTypes();
            int i = 0;
            while (i < classes.length) {
                Class<?> loopClazz = classes[i];
                if (!DocumentMethod.isBaseType(loopClazz)) {
                    parameterClass = loopClazz;
                    parameterGenericMap = DocumentMethod.getGenericMap(parameterGenericMap, parameterClass, typeClasses[i]);
                    break;
                }
                ++i;
            }
            returnClass = m.getReturnType();
            returnGenericMap = DocumentMethod.getGenericMap(returnGenericMap, returnClass, m.getGenericReturnType());
        } else {
            try {
                m = method.getClass().getMethod("handle", String.class, DtObject.class, Request.class, Response.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                _Logger.warn("\u5ffd\u7565\u83b7\u53d6\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
                return null;
            }
            docmethod = m.getAnnotation(DocMethod.class);
            docparameter = m.getAnnotation(DocParameter.class);
            docreturn = m.getAnnotation(DocReturn.class);
            returnClass = null;
        }
        if (docmethod == null) {
            return null;
        }
        vo.name = DocumentMethod.convention(StringUtil.isEmpty((String)docmethod.name()) ? name : docmethod.name());
        vo.title = docmethod.title();
        vo.description = docmethod.description();
        vo.docAccessLevel = docmethod.docAccessLevel();
        vo.index = index + docmethod.index();
        if (docparameter != null) {
            ArrayList<DocAttributeVo> list = new ArrayList<DocAttributeVo>();
            DocAttribute[] docAttributeArray = docparameter.value();
            int classes = docAttributeArray.length;
            int docMethods = 0;
            while (docMethods < classes) {
                DocAttribute a = docAttributeArray[docMethods];
                list.add(DocumentMethod.toAttribute(commons, a, null));
                ++docMethods;
            }
            Collections.sort(list);
            vo.params = list;
        } else {
            DocObjectVo detail2 = DocumentMethod.getDetail(commons, parameterClass, parameterGenericMap);
            vo.params = detail2 != null ? detail2.attributes : Collections.emptyList();
        }
        DocAttributeVo returnVo = new DocAttributeVo();
        if (docreturn != null) {
            if (Void.class != docreturn.type()) {
                returnClass = docreturn.type();
            }
            if (Void.class != docreturn.component()) {
                returnGenericMap.put("E", docreturn.component());
            }
            returnVo.description = docreturn.description();
            if (docreturn.necessary()) {
                returnVo.marks |= 1;
            }
            returnVo.example = docreturn.example();
        }
        returnVo.type = DocumentMethod.getType(returnClass);
        assert (returnClass != null);
        if (returnClass.isArray()) {
            returnVo.component = DocumentMethod.getType(returnClass.getComponentType());
        } else if (ResultPage.class.isAssignableFrom(returnClass)) {
            returnVo.component = DocumentMethod.getType(returnGenericMap.get("E"));
        } else if (Collection.class.isAssignableFrom(returnClass)) {
            returnVo.component = DocumentMethod.getType(returnGenericMap.get("E"));
        } else if (Iterable.class.isAssignableFrom(returnClass)) {
            returnVo.component = DocumentMethod.getType(returnGenericMap.get("T"));
        }
        if (docreturn != null && docreturn.value().length > 0) {
            detail = new DocObjectVo();
            detail.description = returnVo.description;
            ArrayList<DocAttributeVo> attrs = new ArrayList<DocAttributeVo>();
            DocAttribute[] docAttributeArray = docreturn.value();
            int n = docAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DocAttribute a = docAttributeArray[n2];
                attrs.add(DocumentMethod.toAttribute(commons, a, null));
                ++n2;
            }
            Collections.sort(attrs);
            detail.attributes = attrs;
        } else {
            detail = DocumentMethod.getDetail(commons, returnClass, returnGenericMap);
            if (StringUtil.isEmpty((String)returnVo.description) && detail != null) {
                returnVo.description = detail.description;
            }
        }
        returnVo.detail = detail;
        vo.returns = Collections.singletonList(returnVo);
        return vo;
    }

    private List<DocStatusCodeVo> toStatusCodes(Class<?> statusCodeClass) {
        List returnVal;
        Method getCodes;
        if (statusCodeClass == null) {
            return Collections.emptyList();
        }
        try {
            getCodes = statusCodeClass.getMethod("getCodes", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            _Logger.warn("\u83b7\u53d6\u65b9\u6cd5\u51fa\u9519", (Throwable)e);
            return Collections.emptyList();
        }
        try {
            returnVal = (List)getCodes.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            _Logger.warn("\u83b7\u53d6\u65b9\u6cd5\u51fa\u9519", (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<DocStatusCodeVo> list = new ArrayList<DocStatusCodeVo>();
        for (StatusCode code : returnVal) {
            if (DocumentMethod.isInnerCode(code)) continue;
            DocStatusCodeVo vo = new DocStatusCodeVo();
            vo.code = code.code;
            vo.message = code.msg;
            list.add(vo);
        }
        return list;
    }

    private static DocObjectVo getDetail(List<DocObjectVo> commons, Class<?> type, Map<String, Type> genericMap) {
        if (type == null) {
            return null;
        }
        if (DocumentMethod.isBaseType(type)) {
            return null;
        }
        Type component = null;
        if (type.isArray()) {
            component = type.getComponentType();
        }
        if (genericMap != null) {
            if (ResultPage.class.isAssignableFrom(type)) {
                component = genericMap.get("E");
            } else if (Collection.class.isAssignableFrom(type)) {
                component = genericMap.get("E");
            } else if (Iterable.class.isAssignableFrom(type)) {
                component = genericMap.get("T");
            }
        }
        if (component != null) {
            if (DocumentMethod.isBaseType(component)) {
                return null;
            }
            String componentType = DocumentMethod.getType(component);
            for (DocObjectVo vo : commons) {
                if (!StringUtil.eq((String)vo.name, (String)componentType)) continue;
                return null;
            }
            if (component instanceof Class) {
                return DocumentMethod.toObject(commons, component, genericMap);
            }
            return null;
        }
        String typeName = DocumentMethod.getType(type);
        for (DocObjectVo vo : commons) {
            if (!StringUtil.eq((String)vo.name, (String)typeName)) continue;
            return null;
        }
        return DocumentMethod.toObject(commons, type, genericMap);
    }

    public static DocObjectVo toObject(List<DocObjectVo> commons, Class<?> clazz, Map<String, Type> genericMap) {
        GenericClass key = new GenericClass(clazz, genericMap);
        DocObjectVo vo = OBJECT_MAP.get(key);
        if (vo != null) {
            return vo;
        }
        vo = new DocObjectVo();
        DocObjectVo old = OBJECT_MAP.putIfAbsent(key, vo);
        if (old != null) {
            return old;
        }
        ArrayList<DocObjectVo> history = new ArrayList<DocObjectVo>(commons);
        history.add(vo);
        cn.weforward.protocol.doc.annotation.DocObject doc = clazz.getAnnotation(cn.weforward.protocol.doc.annotation.DocObject.class);
        if (doc == null) {
            vo.name = clazz.getSimpleName();
        } else {
            vo.name = StringUtil.isEmpty((String)doc.name()) ? clazz.getSimpleName() : doc.name();
            vo.description = doc.description();
            vo.index = doc.index();
        }
        List<DocAttributeVo> vos = DocumentMethod.getAttributes(history, clazz, genericMap);
        Collections.sort(vos);
        vo.attributes = vos;
        return vo;
    }

    private static List<DocAttributeVo> getAttributes(List<DocObjectVo> commons, Class<?> clazz, Map<String, Type> genericMap) {
        Type raw;
        Type type;
        String typeName;
        Map<String, Type> myGenericMap;
        Type genericReturnType;
        Class returnType;
        String name;
        DocAttributeVo vo;
        DocAttribute attr;
        int n;
        int n2;
        AccessibleObject[] accessibleObjectArray;
        ArrayList<DocAttributeVo> vos = new ArrayList<DocAttributeVo>();
        Class<?> loop = clazz;
        while (loop != null && loop != Object.class) {
            accessibleObjectArray = loop.getDeclaredFields();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                AccessibleObject f = accessibleObjectArray[n];
                attr = ((Field)f).getAnnotation(DocAttribute.class);
                if (attr != null) {
                    vo = DocumentMethod.toAttribute(commons, attr, genericMap);
                    if (StringUtil.isEmpty((String)vo.name)) {
                        name = ((Field)f).getName();
                        if (name.startsWith("m_")) {
                            name = String.valueOf(Character.toLowerCase(name.charAt(2))) + name.substring(3);
                        }
                        vo.name = DocumentMethod.convention(name);
                    }
                    if (StringUtil.isEmpty((String)vo.type)) {
                        returnType = ((Field)f).getType();
                        genericReturnType = ((Field)f).getGenericType();
                        myGenericMap = DocumentMethod.getGenericMap(genericMap, returnType, genericReturnType);
                        if (returnType != genericReturnType) {
                            typeName = genericReturnType.getTypeName();
                            type = myGenericMap.get(typeName);
                            if (type instanceof Class) {
                                returnType = (Class)type;
                            } else if (type instanceof ParameterizedType && (raw = ((ParameterizedType)type).getRawType()) instanceof Class) {
                                returnType = (Class)raw;
                                myGenericMap = DocumentMethod.getGenericMap(myGenericMap, returnType, type);
                            }
                        }
                        vo.type = DocumentMethod.getType(returnType);
                        if (returnType.isArray()) {
                            vo.component = DocumentMethod.getType(returnType.getComponentType());
                        } else if (Iterable.class.isAssignableFrom(returnType)) {
                            vo.component = DocumentMethod.getType(myGenericMap.get("E"));
                        }
                        vo.detail = DocumentMethod.getDetail(commons, returnType, myGenericMap);
                    }
                    vos.add(vo);
                }
                ++n;
            }
            loop = loop.getSuperclass();
        }
        if (clazz != null) {
            accessibleObjectArray = clazz.getMethods();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                AccessibleObject m = accessibleObjectArray[n];
                attr = ((Method)m).getAnnotation(DocAttribute.class);
                if (attr != null) {
                    vo = DocumentMethod.toAttribute(commons, attr, genericMap);
                    if (StringUtil.isEmpty((String)vo.name)) {
                        name = ((Method)m).getName();
                        if (name.startsWith("get") && name.length() > 3 || name.startsWith("set") && name.length() > 3) {
                            name = String.valueOf(Character.toLowerCase(name.charAt(3))) + name.substring(4);
                        } else if (name.startsWith("is") && name.length() > 2) {
                            name = String.valueOf(Character.toLowerCase(name.charAt(2))) + name.substring(3);
                        }
                        vo.name = DocumentMethod.convention(name);
                    }
                    if (StringUtil.isEmpty((String)vo.type)) {
                        returnType = ((Method)m).getReturnType();
                        genericReturnType = ((Method)m).getGenericReturnType();
                        myGenericMap = DocumentMethod.getGenericMap(genericMap, returnType, genericReturnType);
                        if (returnType != genericReturnType) {
                            typeName = genericReturnType.getTypeName();
                            type = myGenericMap.get(typeName);
                            if (type instanceof Class) {
                                returnType = (Class)type;
                            } else if (type instanceof ParameterizedType && (raw = ((ParameterizedType)type).getRawType()) instanceof Class) {
                                returnType = (Class)raw;
                                myGenericMap = DocumentMethod.getGenericMap(myGenericMap, returnType, type);
                            }
                        }
                        vo.type = DocumentMethod.getType(returnType);
                        if (returnType.isArray()) {
                            vo.component = DocumentMethod.getType(returnType.getComponentType());
                        } else if (ResultPage.class.isAssignableFrom(returnType)) {
                            vo.component = DocumentMethod.getType(myGenericMap.get("E"));
                        } else if (Collection.class.isAssignableFrom(returnType)) {
                            vo.component = DocumentMethod.getType(myGenericMap.get("E"));
                        } else if (Iterable.class.isAssignableFrom(returnType)) {
                            vo.component = DocumentMethod.getType(myGenericMap.get("T"));
                        }
                        vo.detail = DocumentMethod.getDetail(commons, returnType, myGenericMap);
                    }
                    vos.add(vo);
                }
                ++n;
            }
        }
        return vos;
    }

    private static DocAttributeVo toAttribute(List<DocObjectVo> commons, DocAttribute a, Map<String, Type> genericMap) {
        Class component;
        DocAttributeVo avo = new DocAttributeVo();
        avo.name = DocumentMethod.convention(a.name());
        avo.type = DocumentMethod.getType(a.type());
        avo.index = a.index();
        avo.component = DocumentMethod.getType(a.component());
        avo.description = a.description();
        avo.example = a.example();
        if (a.necessary()) {
            avo.marks |= 1;
        }
        if ((component = a.component()) != null && Void.class != component) {
            if (genericMap == null) {
                genericMap = new HashMap<String, Type>();
            }
            genericMap.put("E", a.component());
        }
        avo.detail = DocumentMethod.getDetail(commons, a.type(), genericMap);
        return avo;
    }

    private static boolean isBaseType(Type clazzType) {
        if (!(clazzType instanceof Class)) {
            return false;
        }
        Class type = (Class)clazzType;
        return type.isPrimitive() || String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || DtBase.class.isAssignableFrom(type) || FriendlyObject.class.isAssignableFrom(type) || ObjectMapper.class.isAssignableFrom(type);
    }

    private static String getType(Type clazzType) {
        Class type = null;
        if (clazzType instanceof Class) {
            type = (Class)clazzType;
        } else if (clazzType instanceof ParameterizedType) {
            return DocumentMethod.getType(((ParameterizedType)clazzType).getRawType());
        }
        if (type == Void.class || type == null) {
            return null;
        }
        if (BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type)) {
            return DataType.STRING.value;
        }
        if (Number.class.isAssignableFrom(type) || type == Short.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Double.TYPE || type == Long.TYPE || type == Byte.TYPE) {
            return DataType.NUMBER.value;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return DataType.STRING.value;
        }
        if (Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE) {
            return DataType.BOOLEAN.value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return DataType.DATE.value;
        }
        if (type.isArray()) {
            return DataType.LIST.value;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return DataType.LIST.value;
        }
        cn.weforward.protocol.doc.annotation.DocObject v = type.getAnnotation(cn.weforward.protocol.doc.annotation.DocObject.class);
        if (v != null && !StringUtil.isEmpty((String)v.name())) {
            return v.name();
        }
        return type.getSimpleName();
    }

    private static boolean isInnerCode(StatusCode code) {
        return code.code < 100000;
    }

    private static String convention(String name) {
        return NamingConverter.camelToWf((String)name);
    }

    private static Map<String, Type> getGenericMap(Map<String, Type> genericMap, Class<?> clazz, Type classType) {
        HashMap<String, Type> myGenericMap = new HashMap<String, Type>();
        if (genericMap != null) {
            myGenericMap.putAll(genericMap);
        }
        if (classType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)classType;
            TypeVariable<Class<?>>[] typeParams = clazz.getTypeParameters();
            Type[] types = pType.getActualTypeArguments();
            if (types != null && types.length == typeParams.length) {
                int i = 0;
                while (i < types.length) {
                    Type type = types[i];
                    myGenericMap.put(typeParams[i].getName(), type);
                    ++i;
                }
            }
        }
        return myGenericMap;
    }

    private static class GenericClass {
        private final Class<?> m_Clazz;
        private final Map<String, Type> m_GenericMap;

        public GenericClass(Class<?> clazz, Map<String, Type> genericMap) {
            this.m_Clazz = clazz;
            this.m_GenericMap = genericMap;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GenericClass) {
                GenericClass c = (GenericClass)obj;
                if (!this.m_Clazz.equals(c.getClass())) {
                    return false;
                }
                if (this.m_GenericMap == null) {
                    return c.m_GenericMap == null;
                }
                if (c.m_GenericMap == null) {
                    return false;
                }
                return this.m_GenericMap.equals(c.m_GenericMap);
            }
            return false;
        }

        public int hashCode() {
            return this.m_Clazz.hashCode();
        }
    }
}

