/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.doc;

import cn.weforward.framework.doc.DocObjectBuilder;
import cn.weforward.protocol.datatype.DataType;
import cn.weforward.protocol.doc.DocAttribute;
import cn.weforward.protocol.doc.DocObject;
import cn.weforward.protocol.support.doc.DocAttributeVo;
import cn.weforward.protocol.support.doc.DocObjectVo;
import java.util.Collection;
import java.util.Date;

public class DocAttributeBuilder {
    private DocAttributeVo m_Vo;

    private DocAttributeBuilder(DocAttributeVo vo) {
        this.m_Vo = vo;
    }

    public static DocAttributeBuilder valueOf(String name, String description, Class<?> type) {
        DocAttributeVo vo = new DocAttributeVo();
        vo.name = name;
        vo.description = description;
        vo.type = DocAttributeBuilder.getType(type);
        return new DocAttributeBuilder(vo);
    }

    public DocAttributeBuilder component(Class<?> clazz) {
        this.m_Vo.component = DocAttributeBuilder.getType(clazz);
        return this;
    }

    public DocAttributeBuilder example(String example) {
        this.m_Vo.example = example;
        return this;
    }

    public DocAttributeBuilder detail(DocObjectBuilder detailBuilder) {
        return this.detail(detailBuilder.build());
    }

    public DocAttributeBuilder detail(DocObject detail) {
        this.m_Vo.detail = DocObjectVo.valueOf((DocObject)detail);
        return this;
    }

    public DocAttributeBuilder necessary(boolean necessary) {
        this.m_Vo.marks = necessary ? (this.m_Vo.marks |= 1) : (this.m_Vo.marks &= 0);
        return this;
    }

    public DocAttribute build() {
        return this.m_Vo;
    }

    private static String getType(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type == Void.class) {
            return null;
        }
        if (Number.class.isAssignableFrom(type) || type == Short.TYPE || type == Integer.TYPE || type == Long.class || type == Float.TYPE || type == Long.TYPE || type == Byte.TYPE) {
            return DataType.NUMBER.value;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return DataType.STRING.value;
        }
        if (Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE) {
            return DataType.BOOLEAN.value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return DataType.DATE.value;
        }
        if (type.isArray()) {
            return DataType.LIST.value;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return DataType.LIST.value;
        }
        return type.getSimpleName();
    }
}

