/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.debug;

import cn.weforward.common.util.StringUtil;
import cn.weforward.common.util.TransList;
import cn.weforward.framework.ext.WeforwardScript;
import cn.weforward.framework.util.VersionUtil;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.support.datatype.SimpleDtList;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class VersionScript
implements WeforwardScript {
    private static final Logger _Logger = LoggerFactory.getLogger(VersionScript.class);
    private static DtObject VERSION;

    private static DtObject getVersion() throws IOException {
        if (VERSION != null) {
            return VERSION;
        }
        String current = "";
        String jar = VersionUtil.findJarName(VersionScript.class);
        ArrayList<String> weforwardlib = new ArrayList<String>();
        ArrayList<String> otherlib = new ArrayList<String>();
        if (!StringUtil.isEmpty((String)jar)) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JarFile file = new JarFile(jar);){
                Manifest mf = file.getManifest();
                Attributes main = mf.getMainAttributes();
                String libtag = "BOOT-INF/lib/";
                String jartag = ".jar";
                String jarname = file.getName();
                int index = jarname.lastIndexOf(File.separator);
                current = String.valueOf(jarname.substring(index + 1, jarname.length() - jartag.length())) + "-" + main.getValue("Implementation-Version");
                Enumeration<JarEntry> e = file.entries();
                while (e.hasMoreElements()) {
                    String name = e.nextElement().getName();
                    if (!name.startsWith(libtag) || !name.endsWith(jartag)) continue;
                    if ((name = name.substring(libtag.length(), name.length() - jartag.length())).startsWith("weforward-")) {
                        weforwardlib.add(name);
                        continue;
                    }
                    otherlib.add(name);
                }
                Collections.sort(weforwardlib);
                Collections.sort(otherlib);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        SimpleDtObject version = new SimpleDtObject();
        version.put("current", current);
        version.put("weforward_lib", (DtBase)SimpleDtList.valueOf((List)new TransList<DtBase, String>(weforwardlib){

            protected DtBase trans(String src) {
                return new SimpleDtString(src);
            }
        }));
        version.put("other_lib", (DtBase)SimpleDtList.valueOf((List)new TransList<DtBase, String>(otherlib){

            protected DtBase trans(String src) {
                return new SimpleDtString(src);
            }
        }));
        VERSION = version;
        return VERSION;
    }

    @Override
    public DtObject handle(ApplicationContext context, String path, FriendlyObject params) {
        try {
            return VersionScript.getVersion();
        }
        catch (IOException e) {
            _Logger.warn("\u83b7\u53d6\u7248\u672c\u5f02\u5e38", (Throwable)e);
            SimpleDtObject result = new SimpleDtObject();
            result.put("error", e.getMessage());
            return result;
        }
    }
}

