/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_METHOD_NOT_EXISTS = 10001;
    public static final int CODE_AUTH_FAILED = 10002;
    public static final int CODE_NO_LOGIN = 10003;
    public static final int CODE_NEED_VERIFY_PHONE = 10004;
    public static final int CODE_ILLEGAL_ARGUMENT = 20001;
    public static final int CODE_INTERNAL_ERROR = 30001;
    public static final int CODE_BUSINESS_ERROR = 100000000;
    public static final ApiException NO_LOGIN = new ApiException(10003, "\u672a\u767b\u5f55");
    public static final ApiException AUTH_FAILED = new ApiException(10002, "\u65e0\u6743\u9650\u8c03\u7528\u6b64\u65b9\u6cd5");
    public static final ApiException METHOD_NOT_EXISTS = new ApiException(10001, "\u65b9\u6cd5\u4e0d\u5b58\u5728");
    public static final ApiException METHOD_KIND_NO_MATCH = new ApiException(10002, "\u8bbf\u95ee\u51ed\u8bc1\u7c7b\u578b\u4e0d\u5339\u914d");
    protected int m_Code;
    protected String m_Message;

    public ApiException(int code, Throwable e) {
        this(code, e.getMessage(), e);
    }

    public ApiException(int code, String message) {
        this(code, message, null);
    }

    public ApiException(int code, String message, Throwable e) {
        super(ApiException.genTip(code, message), e);
        this.m_Code = code;
        this.m_Message = message;
    }

    public int getCode() {
        return this.m_Code;
    }

    @Override
    public String getMessage() {
        return this.m_Message;
    }

    public static String genTip(int code, String message) {
        return String.valueOf(code) + "/" + message;
    }

    @Override
    public String toString() {
        return ApiException.genTip(this.m_Code, this.m_Message);
    }
}

