/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.boot.support;

import cn.weforward.common.Destroyable;
import cn.weforward.common.sys.Shutdown;
import cn.weforward.common.util.StringUtil;
import java.io.Console;
import java.util.Arrays;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class AbstractSpringApp {
    protected static final Logger _Logger = LoggerFactory.getLogger(AbstractSpringApp.class);
    public static final String SERVERID_KEY = "weforward.serverid";
    public static final String SERVERID_DEFAULT = "x00ff";
    public static final String INPUT_PROP_KEY = "wefoward.input.prop";
    public static final String SPRING_CONFIG_NAME = "weforward.springconfig";
    private static Destroyable DESTROYABLE_RUNNING;

    protected static void init() {
        String sid;
        String inputprop = System.getProperty(INPUT_PROP_KEY);
        if (!StringUtil.isEmpty((String)inputprop)) {
            block14: {
                Console console = System.console();
                String[] arr = inputprop.split(";");
                if (console == null) {
                    System.out.println("no console use scanner");
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (Scanner scanner = new Scanner(System.in);){
                        String[] stringArray = arr;
                        int n = arr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            System.out.print("Please Enter " + key + ":");
                            String value = scanner.nextLine();
                            System.setProperty(key, new String(value));
                            System.out.println();
                            ++n2;
                        }
                        scanner.close();
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                String[] stringArray = arr;
                int n = arr.length;
                int n3 = 0;
                while (n3 < n) {
                    String key = stringArray[n3];
                    char[] value = console.readPassword("Please Enter " + key + ":", new Object[0]);
                    System.setProperty(key, new String(value));
                    ++n3;
                }
            }
            System.out.println("ok..");
        }
        if ((sid = System.getProperty(SERVERID_KEY)) == null || sid.trim().length() == 0) {
            _Logger.warn("\u672a\u6307\u5b9aweforward.serverid\u9ed8\u8ba4\u4f7f\u7528x00ff");
            sid = SERVERID_DEFAULT;
            System.setProperty(SERVERID_KEY, sid);
        }
    }

    protected static void initError(Throwable e) {
        _Logger.error("\u521d\u59cb\u5316Spring\u5bb9\u5668\u5f02\u5e38", e);
        System.err.println("\u521d\u59cb\u5316Spring\u5bb9\u5668\u5f02\u5e38");
        e.printStackTrace(System.err);
        System.exit(1);
    }

    public static void end(final ApplicationContext ac) {
        _Logger.info("start success " + Arrays.toString(ac.getBeanDefinitionNames()));
        DESTROYABLE_RUNNING = new Destroyable(){

            public void destroy() {
                if (ac instanceof ConfigurableApplicationContext) {
                    ((ConfigurableApplicationContext)ac).close();
                    _Logger.info("close success");
                }
                _Logger.info("destroy success");
            }
        };
        Shutdown.register((Destroyable)DESTROYABLE_RUNNING);
    }
}

