/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVLogger;
import cn.leancloud.AVUser;
import cn.leancloud.RequestAuth;
import cn.leancloud.core.PaasClient;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

class RequestUserParser {
    private static AVLogger LOGGER = LogUtil.getLogger(RequestUserParser.class);

    RequestUserParser() {
    }

    public static void parse(final HttpServletRequest req) {
        if (req.getAttribute("requestAuth") == null) {
            return;
        }
        String sessionToken = ((RequestAuth)req.getAttribute("requestAuth")).getSessionToken();
        if (sessionToken != null && !StringUtil.isEmpty((String)sessionToken)) {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("X-LC-Session", sessionToken);
            PaasClient.getStorageClient().createUserBySession(sessionToken, AVUser.class).subscribe((Observer)new Observer<AVUser>(){

                public void onSubscribe(Disposable disposable) {
                }

                public void onNext(AVUser avUser) {
                    AVUser.changeCurrentUser((AVUser)avUser, (boolean)true);
                    req.setAttribute("authUser", (Object)avUser);
                }

                public void onError(Throwable throwable) {
                    LOGGER.w(throwable);
                }

                public void onComplete() {
                }
            });
        }
    }
}

