/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.common;

import cn.com.antcloud.api.acapi.StringUtils;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SDKUtils {
    private static Random random = new Random();

    public static <T> T checkNotNull(T arg) {
        if (arg == null) {
            throw new NullPointerException();
        }
        return arg;
    }

    public static <T> T checkNotNull(T arg, String message) {
        if (arg == null) {
            throw new NullPointerException(message);
        }
        return arg;
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static String generateReqBizId() {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormat.format(new Date(), sb, new FieldPosition(0));
        sb.append(String.format("%09d", random.nextInt(1000000000)));
        sb.append(String.format("%06d", random.nextInt(1000000)));
        return sb.toString();
    }

    public static String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public static String formatNullableDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public static String generateReqMsgId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String underline2Camel(String line, boolean smallCamel) {
        if (StringUtils.isEmpty(line)) {
            return "";
        }
        StringBuilder stringBuffer = new StringBuilder();
        Pattern pattern = Pattern.compile("([A-Za-z\\d]+)(_)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            stringBuffer.append(smallCamel && matcher.start() == 0 ? Character.toLowerCase(word.charAt(0)) : Character.toUpperCase(word.charAt(0)));
            int index = word.lastIndexOf(95);
            if (index > 0) {
                stringBuffer.append(word.substring(1, index).toLowerCase());
                continue;
            }
            stringBuffer.append(word.substring(1).toLowerCase());
        }
        return stringBuffer.toString();
    }

    public static String camel2Underline(String line) {
        if (StringUtils.isEmpty(line)) {
            return "";
        }
        line = String.valueOf(line.charAt(0)).toUpperCase().concat(line.substring(1));
        StringBuilder stringBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("[A-Z]([a-z\\d]+)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            stringBuilder.append(word.toLowerCase());
            stringBuilder.append(matcher.end() == line.length() ? "" : "_");
        }
        return stringBuilder.toString();
    }
}

