/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.acapi;

import cn.com.antcloud.api.acapi.ApacheIdleConnectionCleaner;
import cn.com.antcloud.api.acapi.HttpConfig;
import cn.com.antcloud.api.common.ClientException;
import cn.com.antcloud.api.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class AntCloudHttpClient
implements Closeable {
    private HttpConfig httpConfig;
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;

    public AntCloudHttpClient(final HttpConfig config) {
        this.httpConfig = config;
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeoutMillis()).setSocketTimeout(config.getReadTimeoutMillis()).setConnectionRequestTimeout(config.getWriteTimeoutMillis()).build();
        builder.setDefaultRequestConfig(defaultConfig);
        if (config.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(config.getProxyHost(), config.getProxyPort().intValue(), config.getProxyType().toString());
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword()));
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create();
        socketFactoryRegistryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            socketFactoryRegistryBuilder.register("https", (Object)connectionFactory);
        }
        catch (Exception e) {
            throw new ClientException("SDK.InitFailed, Init https with SSL certs ignore failed", e);
        }
        if (config.isEnableConnectionPools()) {
            this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
            this.connectionManager.setMaxTotal(config.getMaxRequests());
            this.connectionManager.setDefaultMaxPerRoute(config.getMaxRequestsPerHost());
            builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
            ApacheIdleConnectionCleaner.registerConnectionManager((HttpClientConnectionManager)this.connectionManager, config.getMaxIdleTimeMillis());
        }
        if (config.getKeepAliveDurationMillis() > 0) {
            builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                    if (duration > 0L && duration < (long)config.getKeepAliveDurationMillis()) {
                        return duration;
                    }
                    return config.getKeepAliveDurationMillis();
                }
            });
        }
        this.httpClient = builder.build();
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpResponse invoke(HttpUriRequest request) throws IOException {
        return this.httpClient.execute(request);
    }

    @Override
    public void close() throws IOException {
        ApacheIdleConnectionCleaner.removeConnectionManager((HttpClientConnectionManager)this.connectionManager);
        this.connectionManager.shutdown();
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }
}

