/*
 * Decompiled with CFR 0.152.
 */
package step.resources;

import ch.exense.commons.io.FileHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.bson.types.ObjectId;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import step.core.AbstractContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.objectenricher.ObjectEnricher;
import step.core.objectenricher.ObjectHookRegistry;
import step.resources.Resource;
import step.resources.ResourceAccessor;
import step.resources.ResourceManager;
import step.resources.ResourceRevisionContent;
import step.resources.ResourceRevisionContentImpl;
import step.resources.ResourceUploadResponse;
import step.resources.SimilarResourceExistingException;

@Path(value="/resources")
public class ResourceServices
extends AbstractServices {
    protected ResourceManager resourceManager;
    protected ResourceAccessor resourceAccessor;
    private ObjectHookRegistry objectHookRegistry;
    @Context
    ServletContext context;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.resourceManager = (ResourceManager)this.getContext().get(ResourceManager.class);
        this.resourceAccessor = (ResourceAccessor)this.getContext().get(ResourceAccessor.class);
        this.objectHookRegistry = (ObjectHookRegistry)this.getContext().get(ObjectHookRegistry.class);
    }

    @POST
    @Secured
    @Path(value="/content")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public ResourceUploadResponse createResource(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="type") String resourceType, @QueryParam(value="duplicateCheck") Boolean checkForDuplicate) throws Exception {
        ObjectEnricher objectEnricher = this.objectHookRegistry.getObjectEnricher((AbstractContext)this.getSession());
        if (checkForDuplicate == null) {
            checkForDuplicate = true;
        }
        if (uploadedInputStream == null || fileDetail == null) {
            throw new RuntimeException("Invalid arguments");
        }
        if (resourceType == null || resourceType.length() == 0) {
            throw new RuntimeException("Missing resource type query parameter 'type'");
        }
        try {
            Resource resource = this.resourceManager.createResource(resourceType, uploadedInputStream, fileDetail.getFileName(), checkForDuplicate.booleanValue(), objectEnricher);
            return new ResourceUploadResponse(resource, null);
        }
        catch (SimilarResourceExistingException e) {
            return new ResourceUploadResponse(e.getResource(), e.getSimilarResources());
        }
    }

    @POST
    @Secured
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Resource saveResource(Resource resource) {
        return (Resource)this.resourceAccessor.save((AbstractIdentifiableObject)resource);
    }

    @POST
    @Path(value="/{id}/content")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public ResourceUploadResponse saveResourceContent(@PathParam(value="id") String resourceId, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws Exception {
        if (uploadedInputStream == null || fileDetail == null) {
            throw new RuntimeException("Invalid arguments");
        }
        Resource resource = this.resourceManager.saveResourceContent(resourceId, uploadedInputStream, fileDetail.getFileName());
        return new ResourceUploadResponse(resource, null);
    }

    @GET
    @Secured
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Resource getResource(@PathParam(value="id") String resourceId) throws IOException {
        return (Resource)this.resourceAccessor.get(new ObjectId(resourceId));
    }

    @GET
    @Path(value="/{id}/content")
    public Response getResourceContent(@PathParam(value="id") String resourceId, @QueryParam(value="inline") boolean inline) throws IOException {
        ResourceRevisionContent resourceContent = this.resourceManager.getResourceContent(resourceId);
        return this.getResponseForResourceRevisionContent(resourceContent, inline);
    }

    @DELETE
    @Secured
    @Path(value="/{id}")
    public void deleteResource(@PathParam(value="id") String resourceId) {
        this.resourceManager.deleteResource(resourceId);
    }

    @GET
    @Path(value="/revision/{id}/content")
    public Response getResourceRevisionContent(@PathParam(value="id") String resourceRevisionId, @QueryParam(value="inline") boolean inline) throws IOException {
        ResourceRevisionContentImpl resourceContent = this.resourceManager.getResourceRevisionContent(resourceRevisionId);
        return this.getResponseForResourceRevisionContent((ResourceRevisionContent)resourceContent, inline);
    }

    protected Response getResponseForResourceRevisionContent(final ResourceRevisionContent resourceContent, boolean inline) {
        StreamingOutput fileStream = new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                FileHelper.copy((InputStream)resourceContent.getResourceStream(), (OutputStream)output, (int)2048);
                resourceContent.close();
            }
        };
        String resourceName = resourceContent.getResourceName();
        String mimeType = this.context.getMimeType(resourceName);
        if (mimeType == null) {
            mimeType = resourceName.endsWith(".log") ? "text/plain" : "application/octet-stream";
        }
        String contentDisposition = inline ? "inline" : "attachment";
        String headerValue = String.format(contentDisposition + "; filename=\"%s\"", resourceName);
        return Response.ok((Object)fileStream, (String)mimeType).header("content-disposition", (Object)headerValue).build();
    }
}

