/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.bson.types.ObjectId;
import step.core.AbstractContext;
import step.core.GlobalContext;
import step.core.access.AccessManager;
import step.core.access.Role;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.core.objectenricher.ObjectPredicate;
import step.core.objectenricher.ObjectPredicateFactory;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplateManager;

@Singleton
@Path(value="screens")
public class ScreenTemplateService
extends AbstractServices {
    protected AccessManager accessManager;
    protected ScreenTemplateManager screenTemplateManager;
    protected ScreenInputAccessor screenInputAccessor;
    protected ObjectPredicateFactory objectPredicateFactory;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        GlobalContext context = this.getContext();
        this.accessManager = (AccessManager)context.get(AccessManager.class);
        this.screenInputAccessor = (ScreenInputAccessor)context.get(ScreenInputAccessor.class);
        this.screenTemplateManager = (ScreenTemplateManager)context.get(ScreenTemplateManager.class);
        this.objectPredicateFactory = (ObjectPredicateFactory)context.get(ObjectPredicateFactory.class);
    }

    @GET
    @Secured
    @Produces(value={"application/json"})
    public Set<String> getScreens() {
        HashSet<String> screens = new HashSet<String>();
        this.screenInputAccessor.getAll().forEachRemaining(s -> {
            String screenId = s.getScreenId();
            if (screenId != null) {
                screens.add(screenId);
            }
        });
        return screens;
    }

    @GET
    @Secured
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public List<Input> getInputsForScreen(@PathParam(value="id") String screenId, @Context UriInfo uriInfo) {
        Map<String, Object> contextBindings = this.getContextBindings(uriInfo);
        ObjectPredicate objectPredicate = this.objectPredicateFactory.getObjectPredicate((AbstractContext)this.getSession());
        return this.screenTemplateManager.getInputsForScreen(screenId, contextBindings, objectPredicate);
    }

    @POST
    @Secured
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public List<Input> getInputsForScreen(@PathParam(value="id") String screenId, Object params) {
        ObjectPredicate objectPredicate = this.objectPredicateFactory.getObjectPredicate((AbstractContext)this.getSession());
        Map<String, Object> contextBindings = this.getContextBindings(null);
        if (params != null && params instanceof Map) {
            contextBindings.putAll((Map)params);
        }
        return this.screenTemplateManager.getInputsForScreen(screenId, contextBindings, objectPredicate);
    }

    @GET
    @Secured
    @Path(value="/{screenid}/{inputid}")
    @Produces(value={"application/json"})
    public Input getInputForScreen(@PathParam(value="screenid") String screenId, @PathParam(value="inputid") String inputId, @Context UriInfo uriInfo) {
        return this.getInputsForScreen(screenId, uriInfo).stream().filter(i -> i.getId().equals(inputId)).findFirst().orElse(null);
    }

    @GET
    @Secured
    @Path(value="/input/byscreen/{screenid}")
    @Produces(value={"application/json"})
    public List<ScreenInput> getScreenInputsByScreenId(@PathParam(value="screenid") String screenId) {
        return this.screenInputAccessor.getScreenInputsByScreenId(screenId);
    }

    @GET
    @Secured
    @Path(value="/input/{id}")
    @Produces(value={"application/json"})
    public ScreenInput getInput(@PathParam(value="id") String id) {
        return (ScreenInput)this.screenInputAccessor.get(new ObjectId(id));
    }

    @POST
    @Secured(right="admin")
    @Path(value="/input/{id}/move")
    @Produces(value={"application/json"})
    public void moveInput(@PathParam(value="id") String id, int offset) {
        this.screenTemplateManager.moveInput(id, offset);
    }

    @DELETE
    @Secured(right="admin")
    @Path(value="/input/{id}")
    @Produces(value={"application/json"})
    public void deleteInput(@PathParam(value="id") String id) {
        this.screenInputAccessor.remove(new ObjectId(id));
        this.screenTemplateManager.notifyChange();
    }

    @POST
    @Secured(right="admin")
    @Path(value="/input")
    @Produces(value={"application/json"})
    public void saveInput(ScreenInput screenInput) {
        this.screenInputAccessor.save((AbstractIdentifiableObject)screenInput);
        this.screenTemplateManager.notifyChange();
    }

    private Map<String, Object> getContextBindings(UriInfo uriInfo) {
        HashMap<String, Object> contextBindings = new HashMap<String, Object>();
        Session session = this.getSession();
        if (session != null) {
            contextBindings.put("user", session.getUser().getUsername());
            Role roleInContext = this.accessManager.getRoleInContext(session);
            if (roleInContext != null) {
                String roleName = (String)roleInContext.getAttributes().get("name");
                contextBindings.put("role", roleName);
            }
        }
        if (uriInfo != null) {
            for (String key : uriInfo.getQueryParameters().keySet()) {
                contextBindings.put(key, uriInfo.getQueryParameters().getFirst((Object)key));
            }
        }
        return contextBindings;
    }
}

