/*
 * Decompiled with CFR 0.152.
 */
package step.core.scheduler;

import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import step.core.GlobalContext;
import step.core.controller.ControllerSetting;
import step.core.controller.ControllerSettingAccessor;
import step.core.execution.ExecutionRunnable;
import step.core.execution.ExecutionRunnableFactory;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionParameters;
import step.core.scheduler.ExecutionJob;

public class ExecutionJobFactory
implements JobFactory {
    private GlobalContext context;
    private ExecutionRunnableFactory executionRunnableFactory;
    private ControllerSettingAccessor controllerSettingAccessor;

    public ExecutionJobFactory(GlobalContext context, ExecutionRunnableFactory executionRunnableFactory) {
        this.context = context;
        this.executionRunnableFactory = executionRunnableFactory;
        this.controllerSettingAccessor = new ControllerSettingAccessor(context.getMongoClientSession());
    }

    public Job newJob(TriggerFiredBundle arg0, Scheduler arg1) throws SchedulerException {
        Execution execution;
        JobDataMap data = arg0.getJobDetail().getJobDataMap();
        if (data.containsKey((Object)"ExecutionID")) {
            String executionID = data.getString("ExecutionID");
            execution = (Execution)this.context.getExecutionAccessor().get(executionID);
        } else {
            String schedulerUsername;
            String executionTaskID = data.getString("ExecutionTaskID");
            ExecutionParameters executionParams = (ExecutionParameters)data.get((Object)"ExecutionParameters");
            ControllerSetting schedulerUsernameSetting = this.controllerSettingAccessor.getSettingByKey("scheduler_execution_username");
            if (schedulerUsernameSetting != null && (schedulerUsername = schedulerUsernameSetting.getValue()) != null && schedulerUsername.trim().length() > 0) {
                executionParams.setUserID(schedulerUsername);
            }
            execution = this.executionRunnableFactory.createExecution(executionParams, executionTaskID);
        }
        ExecutionRunnable task = this.executionRunnableFactory.newExecutionRunnable(execution);
        ExecutionJob job = new ExecutionJob(task);
        return job;
    }
}

