/*
 * Decompiled with CFR 0.152.
 */
package step.core.plans;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.bson.types.ObjectId;
import step.artefacts.CallPlan;
import step.artefacts.handlers.PlanLocator;
import step.artefacts.handlers.SelectorHelper;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.dynamicbeans.DynamicJsonObjectResolver;
import step.core.dynamicbeans.DynamicJsonValueResolver;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.core.plans.PlanCompilationResult;
import step.core.plans.PlanCompiler;
import step.core.plans.PlanCompilerException;
import step.core.plans.PlanNavigator;
import step.core.plans.PlanType;
import step.core.plans.PlanTypeRegistry;

@Singleton
@Path(value="plans")
public class PlanServices
extends AbstractServices {
    protected PlanAccessor planAccessor;
    protected PlanTypeRegistry planTypeRegistry;

    @Override
    @PostConstruct
    public void init() {
        this.planAccessor = this.getContext().getPlanAccessor();
        this.planTypeRegistry = (PlanTypeRegistry)this.getContext().get(PlanTypeRegistry.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public Plan newPlan(@QueryParam(value="type") String type, @QueryParam(value="template") String template) throws Exception {
        PlanType planType = this.planTypeRegistry.getPlanType(type);
        Plan plan = planType.newPlan(template);
        return plan;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Secured(right="plan-write")
    public Plan save(Plan plan) {
        return (Plan)this.planAccessor.save((AbstractIdentifiableObject)plan);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public Plan get(@PathParam(value="id") String id) {
        return (Plan)this.planAccessor.get(id);
    }

    @GET
    @Path(value="/{id}/compile")
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public PlanCompilationResult compilePlan(@PathParam(value="id") String id) throws Exception {
        Plan plan = (Plan)this.planAccessor.get(id);
        PlanCompilationResult planCompilationResult = new PlanCompilationResult();
        planCompilationResult = this.compilePlan(plan);
        if (!planCompilationResult.isHasError()) {
            this.save(plan);
        }
        return planCompilationResult;
    }

    @POST
    @Path(value="/compile")
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public PlanCompilationResult compilePlan(Plan plan) {
        PlanType planType = this.planTypeRegistry.getPlanType(plan.getClass());
        PlanCompiler planCompiler = planType.getPlanCompiler();
        PlanCompilationResult planCompilationResult = new PlanCompilationResult();
        try {
            plan = planCompiler.compile(plan);
            planCompilationResult.setPlan(plan);
        }
        catch (PlanCompilerException e) {
            planCompilationResult.setHasError(true);
            planCompilationResult.setErrors(e.getErrors());
        }
        return planCompilationResult;
    }

    @GET
    @Path(value="/{id}/clone")
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public Plan clonePlan(@PathParam(value="id") String id) {
        Plan plan = (Plan)this.planAccessor.get(id);
        PlanType planType = this.planTypeRegistry.getPlanType(plan.getClass());
        Plan clonePlan = planType.clonePlan(plan);
        this.assignNewId(clonePlan.getRoot());
        return clonePlan;
    }

    @POST
    @Path(value="/search")
    @Secured(right="plan-read")
    public Plan get(Map<String, String> attributes) {
        return (Plan)this.planAccessor.findByAttributes(attributes);
    }

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Secured(right="plan-write")
    public void delete(@PathParam(value="id") String id) {
        this.planAccessor.remove(new ObjectId(id));
    }

    @GET
    @Path(value="/{id}/artefacts/{artefactid}/lookup/plan")
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public Plan lookupPlan(@PathParam(value="id") String id, @PathParam(value="artefactid") String artefactId) {
        Plan plan = this.get(id);
        PlanNavigator planNavigator = new PlanNavigator(plan);
        CallPlan artefact = (CallPlan)planNavigator.findArtefactById(artefactId);
        DynamicJsonObjectResolver dynamicJsonObjectResolver = new DynamicJsonObjectResolver(new DynamicJsonValueResolver(this.getContext().getExpressionHandler()));
        SelectorHelper selectorHelper = new SelectorHelper(dynamicJsonObjectResolver);
        PlanLocator planLocator = new PlanLocator(null, this.getContext().getPlanAccessor(), selectorHelper);
        return planLocator.selectPlan(artefact);
    }

    @POST
    @Path(value="/artefacts/clone")
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public AbstractArtefact cloneArtefact(AbstractArtefact artefact) {
        this.assignNewId(artefact);
        return artefact;
    }

    private void assignNewId(AbstractArtefact artefact) {
        artefact.setId(new ObjectId());
        artefact.getChildren().forEach(a -> this.assignNewId((AbstractArtefact)a));
    }
}

