/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.ArrayList;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ControllerPlanRunner;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionLifecycleManager;
import step.core.execution.ExecutionManager;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionStatus;
import step.core.execution.model.ReportExport;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.core.plans.runner.PlanRunnerResult;
import step.core.repositories.ImportResult;
import step.core.repositories.RepositoryObjectManager;
import step.core.repositories.RepositoryObjectReference;

public class ExecutionRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionRunnable.class);
    final RepositoryObjectManager repositoryObjectManager;
    final ExecutionAccessor executionAccessor;
    final ExecutionContext context;
    final ExecutionLifecycleManager executionLifecycleManager;

    public ExecutionRunnable(RepositoryObjectManager repositoryObjectManager, ExecutionAccessor executionAccessor, ExecutionContext context) {
        this.repositoryObjectManager = repositoryObjectManager;
        this.executionAccessor = executionAccessor;
        this.context = context;
        this.executionLifecycleManager = new ExecutionLifecycleManager((ExecutionManager)context.get(ExecutionManager.class), context);
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.executionLifecycleManager.beforePlanImport();
            this.updateStatus(ExecutionStatus.IMPORTING);
            ImportResult importResult = this.importPlan();
            this.executionLifecycleManager.afterImport(importResult);
            if (importResult.isSuccessful()) {
                PlanAccessor planAccessor = this.context.getPlanAccessor();
                Plan plan = (Plan)planAccessor.get(new ObjectId(importResult.getPlanId()));
                this.context.setPlan(plan);
                logger.info("Starting test execution. Execution ID: " + this.context.getExecutionId());
                this.updateStatus(ExecutionStatus.RUNNING);
                ControllerPlanRunner planRunner = new ControllerPlanRunner(this.executionLifecycleManager, this.context);
                PlanRunnerResult result = planRunner.run(plan);
                result.waitForExecutionToTerminate();
                ReportNodeStatus resultStatus = result.getResult();
                this.executionLifecycleManager.updateExecutionResult(this.context, resultStatus);
                logger.debug("Test execution ended. Reporting result.... Execution ID: " + this.context.getExecutionId());
                if (!this.context.isSimulation()) {
                    this.updateStatus(ExecutionStatus.EXPORTING);
                    this.exportExecution(this.context.getExecutionId());
                    logger.info("Test execution ended and reported. Execution ID: " + this.context.getExecutionId());
                } else {
                    logger.info("Test execution simulation ended. Test report isn't reported in simulation mode. Execution ID: " + this.context.getExecutionId());
                }
            } else {
                this.updateStatus(ExecutionStatus.ENDED);
            }
        }
        catch (Throwable e) {
            logger.error("An error occurred while running test. Execution ID: " + this.context.getExecutionId(), e);
        }
        finally {
            this.updateStatus(ExecutionStatus.ENDED);
            this.executionLifecycleManager.executionEnded();
        }
    }

    private void updateStatus(ExecutionStatus newStatus) {
        this.executionLifecycleManager.updateStatus(newStatus);
    }

    private ImportResult importPlan() throws Exception {
        ImportResult importResult;
        RepositoryObjectReference repositoryObjectReference = this.context.getExecutionParameters().getRepositoryObject();
        if (repositoryObjectReference != null) {
            if ("local".equals(repositoryObjectReference.getRepositoryID())) {
                importResult = new ImportResult();
                importResult.setPlanId((String)repositoryObjectReference.getRepositoryParameters().get("planid"));
                importResult.setSuccessful(true);
            } else {
                try {
                    importResult = this.repositoryObjectManager.importPlan(this.context, repositoryObjectReference);
                }
                catch (Exception e) {
                    logger.error("Error while importing repository object " + repositoryObjectReference.toString(), (Throwable)e);
                    importResult = new ImportResult();
                    String error = "Unexpected error while importing plan: " + e.getMessage();
                    ArrayList<String> errors = new ArrayList<String>();
                    errors.add(error);
                    importResult.setErrors(errors);
                }
            }
        } else {
            importResult = null;
        }
        return importResult;
    }

    private void exportExecution(String executionId) {
        Execution execution = (Execution)this.executionAccessor.get(executionId);
        if (execution == null) {
            throw new RuntimeException("Unable to find execution with id " + executionId);
        }
        ReportExport report = this.repositoryObjectManager.exportTestExecutionReport(this.context, execution.getExecutionParameters().getRepositoryObject());
        ArrayList<ReportExport> exports = new ArrayList<ReportExport>();
        exports.add(report);
        execution.setReportExports(exports);
        this.executionAccessor.save((AbstractIdentifiableObject)execution);
    }

    public ExecutionLifecycleManager getExecutionLifecycleManager() {
        return this.executionLifecycleManager;
    }

    public boolean equals(Object obj) {
        return ((ExecutionRunnable)obj).getContext().getExecutionId().equals(this.getContext().getExecutionId());
    }

    public void cleanUp() {
    }
}

