/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.Map;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.artefacts.reports.ReportTreeAccessor;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionLifecycleManager;
import step.core.plans.Plan;
import step.core.plans.runner.PlanRunner;
import step.core.plans.runner.PlanRunnerResult;

public class ControllerPlanRunner
implements PlanRunner {
    private final ExecutionLifecycleManager executionLifecycleManager;
    private final ExecutionContext executionContext;

    public ControllerPlanRunner(ExecutionLifecycleManager executionLifecycleManager, ExecutionContext executionContext) {
        this.executionLifecycleManager = executionLifecycleManager;
        this.executionContext = executionContext;
    }

    public PlanRunnerResult run(Plan plan) {
        this.executionContext.associateThread();
        this.executionContext.setPlan(plan);
        AbstractArtefact root = plan.getRoot();
        ReportNode rootReportNode = this.createAndPersistRootReportNode();
        this.executionLifecycleManager.executionStarted();
        ArtefactHandler.delegateCreateReportSkeleton((ExecutionContext)this.executionContext, (AbstractArtefact)root, (ReportNode)rootReportNode);
        ReportNode planReportNode = ArtefactHandler.delegateExecute((ExecutionContext)this.executionContext, (AbstractArtefact)root, (ReportNode)rootReportNode);
        if (planReportNode != null && planReportNode.getStatus() != null) {
            ReportNodeStatus resultStatus = planReportNode.getStatus();
            rootReportNode.setStatus(resultStatus);
            this.executionContext.getReportNodeAccessor().save((AbstractIdentifiableObject)rootReportNode);
        }
        return new PlanRunnerResult(this.executionContext.getExecutionId(), rootReportNode.getId().toString(), (ReportTreeAccessor)this.executionContext.getReportNodeAccessor());
    }

    public PlanRunnerResult run(Plan plan, Map<String, String> executionParameters) {
        throw new UnsupportedOperationException("Running a plan with execution parameters isn't support by this runner.");
    }

    private ReportNode createAndPersistRootReportNode() {
        ReportNode resultNode = new ReportNode();
        resultNode.setExecutionID(this.executionContext.getExecutionId());
        resultNode.setId(new ObjectId(this.executionContext.getExecutionId()));
        this.executionContext.setReport(resultNode);
        this.executionContext.getReportNodeCache().put(resultNode);
        this.executionContext.getReportNodeAccessor().save((AbstractIdentifiableObject)resultNode);
        this.executionContext.setCurrentReportNode(resultNode);
        return resultNode;
    }
}

