/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.bson.types.ObjectId;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactRegistry;
import step.core.artefacts.reports.ReportNode;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.core.execution.ExecutionRunnable;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.repositories.ArtefactInfo;
import step.core.repositories.RepositoryObjectReference;
import step.core.repositories.TestSetStatusOverview;
import step.core.scheduler.ExecutiontTaskParameters;

@Singleton
@Path(value="controller")
public class ControllerServices
extends AbstractServices {
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/shutdown")
    @Secured(right="admin")
    public void shutdown() {
        new Thread(){

            @Override
            public void run() {
                ControllerServices.this.controller.destroy();
            }
        }.start();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/task")
    @Secured(right="task-write")
    public void schedule(ExecutiontTaskParameters schedule) {
        this.getScheduler().addExecutionTask(schedule);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/task/{id}/execute")
    @Secured(right="plan-execute")
    public String execute(@PathParam(value="id") String executionTaskID) {
        Session session = this.getSession();
        return this.getScheduler().executeExecutionTask(executionTaskID, session.getUser().getUsername());
    }

    @PUT
    @Path(value="/task/{id}")
    @Secured(right="task-write")
    public void enableExecutionTask(@PathParam(value="id") String executionTaskID) {
        this.getScheduler().enableExecutionTask(executionTaskID);
    }

    @DELETE
    @Path(value="/task/{id}")
    @Secured(right="task-delete")
    public void removeExecutionTask(@PathParam(value="id") String executionTaskID, @QueryParam(value="remove") Boolean remove) {
        if (remove != null && remove.booleanValue()) {
            this.getScheduler().removeExecutionTask(executionTaskID);
        } else {
            this.getScheduler().disableExecutionTask(executionTaskID);
        }
    }

    @GET
    @Path(value="/task/{id}")
    @Produces(value={"application/json"})
    @Secured(right="task-read")
    public ExecutiontTaskParameters getExecutionTask(@PathParam(value="id") String executionTaskID) {
        return this.getScheduler().get(executionTaskID);
    }

    @GET
    @Path(value="/task/new")
    @Produces(value={"application/json"})
    @Secured(right="task-write")
    public ExecutiontTaskParameters createExecutionTask(@PathParam(value="id") String executionTaskID) {
        ExecutiontTaskParameters taskParameters = new ExecutiontTaskParameters();
        taskParameters.setActive(true);
        ExecutionParameters executionsParameters = new ExecutionParameters();
        HashMap repositoryParameters = new HashMap();
        executionsParameters.setRepositoryObject(new RepositoryObjectReference("local", repositoryParameters));
        executionsParameters.setMode(ExecutionMode.RUN);
        taskParameters.setExecutionsParameters(executionsParameters);
        return taskParameters;
    }

    @GET
    @Path(value="/task")
    @Produces(value={"application/json"})
    @Secured(right="task-read")
    public List<ExecutiontTaskParameters> getScheduledExecutions() {
        ArrayList<ExecutiontTaskParameters> result = new ArrayList<ExecutiontTaskParameters>();
        Iterator<ExecutiontTaskParameters> it = this.getScheduler().getActiveAndInactiveExecutionTasks();
        int maxSize = this.getContext().getConfiguration().getPropertyAsInteger("tec.services.tasks.maxsize", Integer.valueOf(500));
        while (it.hasNext() && result.size() < maxSize) {
            result.add(it.next());
        }
        return result;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/execution")
    @Secured(right="plan-execute")
    public String execute(ExecutionParameters executionParams) {
        String executionID = this.getScheduler().execute(executionParams);
        return executionID;
    }

    @GET
    @Path(value="/execution/{id}/stop")
    @Secured(right="plan-execute")
    public Void abort(@PathParam(value="id") String executionID) {
        ExecutionRunnable task = this.getExecutionRunnable(executionID);
        if (task != null) {
            task.getExecutionLifecycleManager().abort();
        }
        return null;
    }

    @GET
    @Path(value="/reportnode/{id}")
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public ReportNode getReportNode(@PathParam(value="id") String reportNodeId) {
        return (ReportNode)this.getContext().getReportAccessor().get(new ObjectId(reportNodeId));
    }

    @GET
    @Path(value="/reportnode/{id}/path")
    @Secured(right="execution-read")
    public List<ReportNode> getReportNodePath(@PathParam(value="id") String reportNodeId) {
        ArrayList<ReportNode> result = new ArrayList<ReportNode>();
        List path = this.getContext().getReportAccessor().getReportNodePath(new ObjectId(reportNodeId));
        path.forEach(node -> result.add((ReportNode)node));
        return result;
    }

    @GET
    @Path(value="/reportnode/{id}/children")
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public List<ReportNode> getReportNodeChildren(@PathParam(value="id") String reportNodeId, @QueryParam(value="skip") Integer skip, @QueryParam(value="limit") Integer limit) {
        skip = skip != null ? skip : 0;
        limit = limit != null ? limit : 1000;
        ArrayList<ReportNode> result = new ArrayList<ReportNode>();
        Iterator it = this.getContext().getReportAccessor().getChildren(new ObjectId(reportNodeId), skip.intValue(), limit.intValue());
        while (it.hasNext()) {
            result.add((ReportNode)it.next());
        }
        return result;
    }

    @POST
    @Path(value="/repository/artefact/info")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public ArtefactInfo getArtefactInfo(RepositoryObjectReference ref) {
        try {
            return this.getContext().getRepositoryObjectManager().getArtefactInfo(ref);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((int)500).entity((Object)("Unable to retrieve artefact." + e.getMessage())).type("text/plain").build());
        }
    }

    @POST
    @Path(value="/repository/report")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public TestSetStatusOverview getReport(RepositoryObjectReference report) throws Exception {
        return this.getContext().getRepositoryObjectManager().getReport(report);
    }

    @GET
    @Path(value="/artefact/types")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public Set<String> getArtefactTypes() {
        return ArtefactRegistry.getInstance().getArtefactNames();
    }

    @GET
    @Path(value="/artefact/types/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public AbstractArtefact getArtefactType(@PathParam(value="id") String type) throws Exception {
        return ArtefactRegistry.getInstance().getArtefactTypeInstance(type);
    }
}

