/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import ch.exense.commons.app.Configuration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import step.core.Controller;
import step.core.GlobalContext;
import step.core.deployment.Session;
import step.core.execution.ExecutionRunnable;
import step.core.scheduler.ExecutionScheduler;

public abstract class AbstractServices {
    private static final String SESSION = "session";
    @Inject
    protected Controller controller;
    @Inject
    private HttpSession httpSession;
    protected Configuration configuration;

    @PostConstruct
    public void init() throws Exception {
        this.configuration = this.controller.getContext().getConfiguration();
    }

    protected GlobalContext getContext() {
        return this.controller.getContext();
    }

    protected ExecutionScheduler getScheduler() {
        return this.controller.getScheduler();
    }

    protected ExecutionRunnable getExecutionRunnable(String executionID) {
        for (ExecutionRunnable runnable : this.getScheduler().getCurrentExecutions()) {
            if (!runnable.getContext().getExecutionId().equals(executionID)) continue;
            return runnable;
        }
        return null;
    }

    protected Session getSession() {
        if (this.httpSession != null) {
            return (Session)((Object)this.httpSession.getAttribute(SESSION));
        }
        return null;
    }

    protected void setSession(Session session) {
        this.httpSession.setAttribute(SESSION, (Object)session);
    }
}

