/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import junit.framework.Assert;
import org.bson.types.ObjectId;
import org.junit.Test;
import step.commons.activation.Expression;
import step.core.objectenricher.ObjectPredicate;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.InputType;
import step.plugins.screentemplating.Option;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplateManager;

public class ScreenTemplateManagerTest {
    @Test
    public void test() {
        ScreenInputAccessor a = new ScreenInputAccessor(){

            public List<ScreenInput> getScreenInputsByScreenId(String screenId) {
                if (screenId.equals("testScreen1")) {
                    ArrayList<ScreenInput> result = new ArrayList<ScreenInput>();
                    result.add(new ScreenInput("testScreen1", new Input("Param1")));
                    result.add(new ScreenInput("testScreen1", new Input("Param2", Arrays.asList(new Option("Option1"), new Option("Option2")))));
                    result.add(new ScreenInput("testScreen1", new Input(InputType.TEXT, "Param3", "LabelParam3", Arrays.asList(new Option("Option1"), new Option("Option2"), new Option("Option3", "user=='user1'")))));
                    ScreenInput i = new ScreenInput("testScreen1", new Input(InputType.TEXT, "Param4", "LabelParam4", Arrays.asList(new Option("Option1"), new Option("Option2"))));
                    i.getInput().setActivationExpression(new Expression("user=='user1'"));
                    result.add(i);
                    i = new ScreenInput("testScreen1", new Input("Param5", Arrays.asList(new Option("Option1"), new Option("Option2"))));
                    i.getInput().setActivationExpression(new Expression("user=='user1'"));
                    result.add(i);
                    return result;
                }
                throw new RuntimeException("Unknown screen " + screenId);
            }

            public void remove(ObjectId id) {
            }

            public ScreenInput save(ScreenInput entity) {
                return null;
            }

            public void save(Collection<? extends ScreenInput> entities) {
            }

            public ScreenInput get(ObjectId id) {
                return null;
            }

            public ScreenInput findByAttributes(Map<String, String> attributes) {
                return null;
            }

            public Iterator<ScreenInput> getAll() {
                return null;
            }

            public Spliterator<ScreenInput> findManyByAttributes(Map<String, String> attributes) {
                return null;
            }

            public ScreenInput findByAttributes(Map<String, String> attributes, String attributesMapKey) {
                return null;
            }

            public Spliterator<ScreenInput> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
                return null;
            }

            public ScreenInput get(String id) {
                return this.get(new ObjectId(id));
            }

            public List<ScreenInput> getRange(int skip, int limit) {
                return null;
            }
        };
        ScreenTemplateManager s = new ScreenTemplateManager(a);
        List inputs = s.getInputsForScreen("testScreen1", new HashMap(), this.newPredicate());
        Assert.assertEquals((int)3, (int)inputs.size());
        Assert.assertEquals(inputs.get(0), (Object)new Input(InputType.TEXT, "Param1", "Param1", null));
        List<Option> options = this.getDefaultOptionList();
        Assert.assertEquals(inputs.get(1), (Object)new Input(InputType.DROPDOWN, "Param2", "Param2", options));
        Assert.assertEquals(inputs.get(2), (Object)new Input(InputType.TEXT, "Param3", "LabelParam3", options));
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("user", "user1");
        inputs = s.getInputsForScreen("testScreen1", ctx, this.newPredicate());
        Assert.assertEquals((int)5, (int)inputs.size());
        Assert.assertEquals(inputs.get(2), (Object)new Input(InputType.TEXT, "Param3", "LabelParam3", this.getOptionListForUser1()));
        Assert.assertEquals(inputs.get(3), (Object)new Input(InputType.TEXT, "Param4", "LabelParam4", options));
        Assert.assertEquals(inputs.get(4), (Object)new Input(InputType.DROPDOWN, "Param5", "Param5", options));
    }

    protected ObjectPredicate newPredicate() {
        return new ObjectPredicate(){

            public boolean test(Object t) {
                return true;
            }
        };
    }

    private List<Option> getDefaultOptionList() {
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(new Option("Option1"));
        options.add(new Option("Option2"));
        return options;
    }

    private List<Option> getOptionListForUser1() {
        ArrayList<Option> options = new ArrayList<Option>(this.getDefaultOptionList());
        options.add(new Option("Option3"));
        return options;
    }
}

