/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;
import step.artefacts.CheckArtefact;
import step.core.GlobalContext;
import step.core.GlobalContextBuilder;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionRunnable;
import step.core.execution.ExecutionRunnableFactory;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.core.plans.builder.PlanBuilder;
import step.core.plugins.AbstractControllerPlugin;
import step.core.repositories.ImportResult;
import step.core.repositories.RepositoryObjectManager;
import step.core.repositories.RepositoryObjectReference;

public class ExecutionRunnableTest {
    @Test
    public void test() throws Exception {
        GlobalContext globalContext = GlobalContextBuilder.createGlobalContext();
        globalContext.getPluginManager().register(new AbstractControllerPlugin(){

            public void executionStart(ExecutionContext context) {
                context.getVariablesManager().putVariable(context.getReport(), "tec.execution.exports", (Object)"[]");
                super.executionStart(context);
            }
        });
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new CheckArtefact(c -> c.getCurrentReportNode().setStatus(ReportNodeStatus.PASSED))).endBlock().build();
        String planId = plan.getId().toString();
        globalContext.getPlanAccessor().save((AbstractIdentifiableObject)plan);
        ImportResult result = new ImportResult();
        result.setSuccessful(true);
        result.setPlanId(planId);
        TestRepositoryObjectManager repo = new TestRepositoryObjectManager(result, globalContext.getPlanAccessor());
        globalContext.setRepositoryObjectManager((RepositoryObjectManager)repo);
        ExecutionRunnableFactory f = new ExecutionRunnableFactory(globalContext);
        ExecutionParameters p = new ExecutionParameters("user", null, ExecutionMode.RUN);
        RepositoryObjectReference ref = new RepositoryObjectReference();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("planid", planId);
        ref.setRepositoryParameters(parameters);
        p.setRepositoryObject(ref);
        p.setExports(new ArrayList());
        Execution e = f.createExecution(p, null);
        ExecutionRunnable r = f.newExecutionRunnable(e);
        r.run();
        Execution execution = (Execution)globalContext.getExecutionAccessor().get(e.getId().toString());
        Assert.assertNotNull((Object)execution);
        Assert.assertNotNull((Object)execution.getStartTime());
        Assert.assertNotNull((Object)execution.getEndTime());
        Assert.assertEquals((Object)ExecutionStatus.ENDED, (Object)execution.getStatus());
        Assert.assertNull((Object)execution.getExecutionTaskID());
        ReportNode node = globalContext.getReportAccessor().getRootReportNode(e.getId().toString());
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)node.getStatus());
    }

    private static class TestRepositoryObjectManager
    extends RepositoryObjectManager {
        private ImportResult result;

        public TestRepositoryObjectManager(ImportResult result, PlanAccessor planAccessor) {
            super(planAccessor);
            this.result = result;
        }

        public ImportResult importPlan(ExecutionContext context, RepositoryObjectReference artefact) throws Exception {
            return this.result;
        }
    }
}

