/*
 * Decompiled with CFR 0.152.
 */
package step.resources;

import ch.exense.commons.app.Configuration;
import java.io.File;
import step.attachments.FileResolver;
import step.core.GlobalContext;
import step.core.accessors.collections.Collection;
import step.core.accessors.collections.CollectionRegistry;
import step.core.execution.ExecutionContext;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.resources.Resource;
import step.resources.ResourceAccessor;
import step.resources.ResourceAccessorImpl;
import step.resources.ResourceManager;
import step.resources.ResourceManagerImpl;
import step.resources.ResourceRevisionAccessor;
import step.resources.ResourceRevisionAccessorImpl;
import step.resources.ResourceServices;

@Plugin
public class ResourcePlugin
extends AbstractControllerPlugin {
    protected ResourceAccessor resourceAccessor;
    protected ResourceRevisionAccessor resourceRevisionAccessor;
    protected ResourceManager resourceManager;
    protected FileResolver fileResolver;

    @Override
    public void executionControllerStart(GlobalContext context) throws Exception {
        this.resourceAccessor = new ResourceAccessorImpl(context.getMongoClientSession());
        this.resourceRevisionAccessor = new ResourceRevisionAccessorImpl(context.getMongoClientSession());
        String resourceRootDir = ResourcePlugin.getResourceDir(context.getConfiguration());
        this.resourceManager = new ResourceManagerImpl(new File(resourceRootDir), this.resourceAccessor, this.resourceRevisionAccessor);
        context.put(ResourceAccessor.class, this.resourceAccessor);
        context.put(ResourceManager.class, this.resourceManager);
        context.getServiceRegistrationCallback().registerService(ResourceServices.class);
        this.fileResolver = new FileResolver(this.resourceManager);
        context.put(FileResolver.class, this.fileResolver);
        ((CollectionRegistry)context.get(CollectionRegistry.class)).register("resources", new Collection<Resource>(context.getMongoClientSession().getMongoDatabase(), "resources", Resource.class, true));
    }

    public static String getResourceDir(Configuration configuration) {
        String resourceRootDir = configuration.getProperty("resources.dir", "resources");
        return resourceRootDir;
    }

    public void executionStart(ExecutionContext context) {
        context.put(FileResolver.class, (Object)this.fileResolver);
        context.put(ResourceManager.class, (Object)this.resourceManager);
    }
}

