/*
 * Decompiled with CFR 0.152.
 */
package step.repositories.staging;

import java.util.Map;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.execution.ExecutionContext;
import step.core.repositories.ArtefactInfo;
import step.core.repositories.ImportResult;
import step.core.repositories.Repository;
import step.core.repositories.TestSetStatusOverview;
import step.functions.accessor.FunctionAccessor;
import step.functions.accessor.FunctionCRUDAccessor;
import step.repositories.staging.StagingContext;
import step.repositories.staging.StagingContextAccessorImpl;

public class StagingRepository
implements Repository {
    protected StagingContextAccessorImpl stagingContextAccessor;

    public StagingRepository(StagingContextAccessorImpl stagingContextRegistry) {
        this.stagingContextAccessor = stagingContextRegistry;
    }

    @Override
    public ArtefactInfo getArtefactInfo(Map<String, String> repositoryParameters) throws Exception {
        StagingContext stagingContext = (StagingContext)((Object)this.stagingContextAccessor.get(repositoryParameters.get("contextid")));
        ArtefactInfo info = new ArtefactInfo();
        info.setType("testplan");
        info.setName((String)stagingContext.getPlan().getRoot().getAttributes().get("name"));
        return info;
    }

    @Override
    public ImportResult importArtefact(ExecutionContext context, Map<String, String> repositoryParameters) throws Exception {
        StagingContext stagingContext = (StagingContext)((Object)this.stagingContextAccessor.get(repositoryParameters.get("contextid")));
        context.getPlanAccessor().save((AbstractIdentifiableObject)stagingContext.plan);
        ImportResult result = new ImportResult();
        result.setPlanId(stagingContext.plan.getId().toString());
        stagingContext.plan.getFunctions().iterator().forEachRemaining(f -> ((FunctionCRUDAccessor)context.get(FunctionAccessor.class)).save((AbstractIdentifiableObject)f));
        result.setSuccessful(true);
        return result;
    }

    @Override
    public TestSetStatusOverview getTestSetStatusOverview(Map<String, String> repositoryParameters) throws Exception {
        return null;
    }

    @Override
    public void exportExecution(ExecutionContext context, Map<String, String> repositoryParameters) throws Exception {
    }
}

