/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import step.commons.activation.Activator;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.objectenricher.ObjectPredicate;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.Option;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplateChangeListener;

public class ScreenTemplateManager {
    protected final List<ScreenTemplateChangeListener> listeners = new ArrayList<ScreenTemplateChangeListener>();
    protected ScreenInputAccessor screenInputAccessor;

    public ScreenTemplateManager(ScreenInputAccessor screenInputAccessor) {
        this.screenInputAccessor = screenInputAccessor;
    }

    public List<Input> getInputsForScreen(String screenId, Map<String, Object> contextBindings, ObjectPredicate objectPredicate) {
        Stream stream = this.screenInputAccessor.getScreenInputsByScreenId(screenId).stream();
        if (objectPredicate != null) {
            stream = stream.filter(objectPredicate);
        }
        List screenInputs = stream.map(i -> i.getInput()).collect(Collectors.toList());
        ArrayList<Input> result = new ArrayList<Input>();
        List inputs = Activator.findAllMatches(contextBindings, screenInputs);
        for (Input input : inputs) {
            List<Option> options = input.getOptions();
            List activeOptions = null;
            if (options != null) {
                activeOptions = Activator.findAllMatches(contextBindings, options);
            }
            Input clone = new Input(input.getType(), input.getId(), input.getLabel(), input.getDescription(), activeOptions);
            clone.setValueHtmlTemplate(input.getValueHtmlTemplate());
            result.add(clone);
        }
        return result;
    }

    public void moveInput(String inputId, int offset) {
        ScreenInput screenInput = (ScreenInput)this.screenInputAccessor.get(new ObjectId(inputId));
        List<ScreenInput> screenInputs = this.screenInputAccessor.getScreenInputsByScreenId(screenInput.getScreenId());
        int indexOf = screenInputs.indexOf((Object)screenInput);
        int newIndex = indexOf + offset;
        if (newIndex >= 0 && newIndex < screenInputs.size()) {
            Collections.swap(screenInputs, indexOf, indexOf + offset);
            for (int i = 0; i < screenInputs.size(); ++i) {
                ScreenInput input = screenInputs.get(i);
                input.setPosition(i);
                this.screenInputAccessor.save((AbstractIdentifiableObject)input);
            }
        }
    }

    public void registerListener(ScreenTemplateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void notifyChange() {
        this.listeners.forEach(l -> l.onChange());
    }
}

