/*
 * Decompiled with CFR 0.152.
 */
package step.core.plans;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.types.ObjectId;
import step.core.GlobalContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.collections.CollectionRegistry;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactRegistry;
import step.core.plans.Plan;
import step.core.plans.PlanCollection;
import step.core.plans.PlanCompiler;
import step.core.plans.PlanServices;
import step.core.plans.PlanType;
import step.core.plans.PlanTypeRegistry;
import step.core.plans.builder.PlanBuilder;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.InputType;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplatePlugin;

@Plugin(dependencies={ScreenTemplatePlugin.class})
public class PlanPlugin
extends AbstractControllerPlugin {
    @Override
    public void executionControllerStart(GlobalContext context) throws Exception {
        PlanTypeRegistry planTypeRegistry = new PlanTypeRegistry();
        planTypeRegistry.register((PlanType)new PlanType<Plan>(){

            public Class<Plan> getPlanClass() {
                return Plan.class;
            }

            public PlanCompiler<Plan> getPlanCompiler() {
                return new PlanCompiler<Plan>(){

                    public Plan compile(Plan plan) {
                        return plan;
                    }
                };
            }

            public Plan newPlan(String template) throws Exception {
                AbstractArtefact artefact = ArtefactRegistry.getInstance().getArtefactTypeInstance(template);
                Plan plan = PlanBuilder.create().startBlock(artefact).endBlock().build();
                return plan;
            }

            public Plan clonePlan(Plan plan) {
                Plan newPlan = plan;
                newPlan.setId(new ObjectId());
                newPlan.setCustomFields(null);
                newPlan.setVisible(true);
                return newPlan;
            }
        });
        context.put(PlanTypeRegistry.class, planTypeRegistry);
        context.getServiceRegistrationCallback().registerService(PlanServices.class);
        ((CollectionRegistry)context.get(CollectionRegistry.class)).register("plans", new PlanCollection(context.getMongoClientSession().getMongoDatabase()));
    }

    @Override
    public void initializeData(GlobalContext context) throws Exception {
        this.createScreenInputDefinitionsIfNecessary(context);
    }

    protected void createScreenInputDefinitionsIfNecessary(GlobalContext context) {
        ScreenInputAccessor screenInputAccessor = (ScreenInputAccessor)context.get(ScreenInputAccessor.class);
        List<ScreenInput> screenInputsByScreenId = screenInputAccessor.getScreenInputsByScreenId("planTable");
        Input nameInput = new Input(InputType.TEXT, "attributes.name", "Name", null, null);
        nameInput.setValueHtmlTemplate("<entity-icon entity=\"stBean\" entity-name=\"'plans'\"/> <plan-link plan-id=\"stBean.id\" description=\"stBean.attributes.name\" st-options=\"stOptions\"/>");
        AtomicBoolean inputExists = new AtomicBoolean(false);
        screenInputsByScreenId.forEach(i -> {
            Input input = i.getInput();
            if (input.getId().equals("attributes.name")) {
                i.setInput(nameInput);
                screenInputAccessor.save((AbstractIdentifiableObject)i);
                inputExists.set(true);
            }
        });
        if (!inputExists.get()) {
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(0, "planTable", nameInput));
        }
    }
}

