/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.attachments.FileResolver;
import step.core.AbstractContext;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.export.ImportManager;
import step.core.objectenricher.ObjectHookRegistry;
import step.core.plans.PlanAccessor;

@Singleton
@Path(value="import")
public class ImportServices
extends AbstractServices {
    private static final Logger logger = LoggerFactory.getLogger(ImportServices.class);
    FileResolver fileResolver;
    ImportManager importManager;
    ObjectHookRegistry objectHookRegistry;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        PlanAccessor accessor = this.getContext().getPlanAccessor();
        this.importManager = new ImportManager(accessor);
        this.fileResolver = (FileResolver)this.getContext().get(FileResolver.class);
        this.objectHookRegistry = (ObjectHookRegistry)this.getContext().get(ObjectHookRegistry.class);
    }

    @POST
    @Path(value="/artefact")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public void importArtefact(@QueryParam(value="path") String path) throws IOException {
        try (FileResolver.FileHandle file = this.fileResolver.resolveFileHandle(path);){
            this.importManager.importPlans(file.getFile(), this.objectHookRegistry.getObjectEnricher((AbstractContext)this.getSession()));
        }
        catch (Exception e) {
            logger.error("Import failed", (Throwable)e);
            throw e;
        }
    }
}

