/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.deployment.JacksonMapperProvider;
import step.core.export.ImportServices;
import step.core.objectenricher.ObjectEnricher;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;

public class ImportManager {
    private static final Logger logger = LoggerFactory.getLogger(ImportServices.class);
    protected final PlanAccessor planAccessor;

    public ImportManager(PlanAccessor planAccessor) {
        this.planAccessor = planAccessor;
    }

    public void importPlans(File file, ObjectEnricher objectEnricher) throws IOException {
        ObjectMapper mapper = JacksonMapperProvider.createMapper();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                Plan plan = (Plan)mapper.readValue(line, Plan.class);
                objectEnricher.accept((Object)plan);
                this.planAccessor.save((AbstractIdentifiableObject)plan);
            }
        }
        catch (Exception e) {
            try {
                this.importArtefacts(file, objectEnricher);
            }
            catch (Exception e2) {
                logger.error("Failed to import plan in version 3.13+", (Throwable)e);
                logger.error("Failed to import plan in version 3.12 and before", (Throwable)e2);
                throw new RuntimeException("Unable to import the plan, check the error logs for more details");
            }
        }
    }

    public void importArtefacts(File file, ObjectEnricher objectEnricher) throws IOException {
        ObjectMapper mapper = JacksonMapperProvider.createMapper();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            String line;
            HashMap<String, AbstractArtefact> artefacts = new HashMap<String, AbstractArtefact>();
            HashMap<String, String[]> artefactsChilds = new HashMap<String, String[]>();
            HashMap<String, ObjectId> rootsToPlanIds = new HashMap<String, ObjectId>();
            Pattern pattern = Pattern.compile("\"childrenIDs\":\\[([^\\]]*)\\],*");
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                String modifiedLine = line;
                modifiedLine = modifiedLine.replaceAll("\"childrenIDs\":\\[[^\\]]*\\],*", "");
                modifiedLine = modifiedLine.replaceAll("\"childrenIDs\":[^,$]*,*", "");
                modifiedLine = modifiedLine.replaceAll("\"root\":[^,$]*,*", "");
                if (line.contains("\"_class\":\"CallPlan\"")) {
                    modifiedLine = modifiedLine.replaceAll("\"artefactId\":", "\"planId\":");
                }
                AbstractArtefact artefact = (AbstractArtefact)mapper.readValue(modifiedLine, AbstractArtefact.class);
                String artefactIdStr = artefact.getId().toString();
                artefacts.put(artefactIdStr, artefact);
                if (line.contains("\"root\":true")) {
                    rootsToPlanIds.put(artefactIdStr, new ObjectId(artefactIdStr));
                }
                if (!(matcher = pattern.matcher(line)).find() || matcher.group(1).isEmpty()) continue;
                artefactsChilds.put(artefactIdStr, matcher.group(1).replaceAll("\"", "").split(","));
            }
            if (rootsToPlanIds.size() <= 0) {
                throw new RuntimeException("No root element found");
            }
            for (String rootId : rootsToPlanIds.keySet()) {
                AbstractArtefact root = (AbstractArtefact)artefacts.get(rootId);
                Plan plan = new Plan();
                plan.setId((ObjectId)rootsToPlanIds.get(rootId));
                plan.setAttributes(root.getAttributes());
                this.addChilds(root, artefacts, artefactsChilds, rootsToPlanIds);
                plan.setRoot(root);
                plan.setVisible(true);
                objectEnricher.accept((Object)plan);
                plan = (Plan)this.planAccessor.save((AbstractIdentifiableObject)plan);
            }
        }
    }

    private void addChilds(AbstractArtefact artefact, Map<String, AbstractArtefact> artefacts, Map<String, String[]> artefactsChilds, Map<String, ObjectId> rootsToPlanIds) {
        if (artefactsChilds.containsKey(artefact.getId().toString())) {
            for (String key : artefactsChilds.get(artefact.getId().toString())) {
                AbstractArtefact child = artefacts.get(key);
                artefact.addChild(child);
                this.addChilds(child, artefacts, artefactsChilds, rootsToPlanIds);
            }
        }
    }
}

