/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import step.core.AbstractContext;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.core.export.ExportManager;
import step.core.export.ExportTaskManager;
import step.core.objectenricher.ObjectPredicateFactory;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.resources.Resource;
import step.resources.ResourceRevisionContainer;

@Singleton
@Path(value="export")
public class ExportServices
extends AbstractServices {
    ExportManager exportManager;
    ExportTaskManager exportTaskManager;
    ObjectPredicateFactory objectPredicateFactory;
    PlanAccessor accessor;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.accessor = this.getContext().getPlanAccessor();
        this.exportTaskManager = (ExportTaskManager)this.getContext().get(ExportTaskManager.class);
        this.objectPredicateFactory = (ObjectPredicateFactory)this.getContext().get(ObjectPredicateFactory.class);
        this.exportManager = new ExportManager(this.accessor);
    }

    @GET
    @Path(value="/plan/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public ExportTaskManager.ExportStatus exportArtefact(final @PathParam(value="id") String id) {
        return this.exportTaskManager.createExportTask(new ExportTaskManager.ExportRunnable(){

            @Override
            public Resource runExport() throws IOException {
                String planName = (String)((Plan)ExportServices.this.accessor.get(id)).getAttributes().get("name");
                ResourceRevisionContainer resourceContainer = this.getResourceManager().createResourceContainer("temp", planName + ".json");
                ExportServices.this.exportManager.exportPlan(id, resourceContainer.getOutputStream());
                resourceContainer.save(null);
                return resourceContainer.getResource();
            }
        });
    }

    @GET
    @Path(value="/plans")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public ExportTaskManager.ExportStatus exportAllArtefacts() {
        final Session session = this.getSession();
        return this.exportTaskManager.createExportTask(new ExportTaskManager.ExportRunnable(){

            @Override
            public Resource runExport() throws FileNotFoundException, IOException {
                ResourceRevisionContainer resourceContainer = this.getResourceManager().createResourceContainer("temp", "Plans.json");
                ExportServices.this.exportManager.exportAllPlans(resourceContainer.getOutputStream(), ExportServices.this.objectPredicateFactory.getObjectPredicate((AbstractContext)session));
                resourceContainer.save(null);
                return resourceContainer.getResource();
            }
        });
    }

    @GET
    @Path(value="/{id}/status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ExportTaskManager.ExportStatus getExportStatus(@PathParam(value="id") String id) {
        return this.exportTaskManager.getExportStatus(id);
    }
}

