/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution.table;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.execution.model.Execution;
import step.core.execution.type.ExecutionType;
import step.core.execution.type.ExecutionTypeManager;

public class ExecutionSummaryProvider {
    private ExecutionTypeManager executionTypeManager;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionSummaryProvider.class);

    public ExecutionSummaryProvider(GlobalContext context) {
        this.executionTypeManager = (ExecutionTypeManager)context.get(ExecutionTypeManager.class);
    }

    public Object format(Execution execution) {
        String executionTypeName = execution.getExecutionType();
        ExecutionType executionType = this.executionTypeManager.get(executionTypeName);
        try {
            if (executionType != null) {
                Object result = executionType.getExecutionSummary(execution.getId().toString());
                return result;
            }
            logger.warn("Execution type " + executionTypeName + " not available");
        }
        catch (Exception e) {
            logger.error("Error while getting execution summary for execution " + execution.getId().toString(), (Throwable)e);
        }
        return null;
    }
}

