/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.HashMap;
import org.bson.types.ObjectId;
import step.core.GlobalContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.execution.ControllerExecutionContextBuilder;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionRunnable;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.core.repositories.RepositoryObjectReference;
import step.core.scheduler.ExecutionTaskAccessor;
import step.core.scheduler.ExecutiontTaskParameters;

public class ExecutionRunnableFactory {
    private GlobalContext globalContext;
    private ControllerExecutionContextBuilder executionContextBuilder;
    private ExecutionTaskAccessor taskAccessor;
    private PlanAccessor planAccessor;

    public ExecutionRunnableFactory(GlobalContext globalContext) {
        this.globalContext = globalContext;
        this.executionContextBuilder = new ControllerExecutionContextBuilder(globalContext);
        this.taskAccessor = globalContext.getScheduleAccessor();
        this.planAccessor = globalContext.getPlanAccessor();
    }

    public ExecutionRunnable newExecutionRunnable(Execution execution) {
        ExecutionContext context = this.executionContextBuilder.createExecutionContext(execution.getId().toString(), execution.getExecutionParameters());
        ExecutionRunnable task = new ExecutionRunnable(this.globalContext.getRepositoryObjectManager(), this.globalContext.getExecutionAccessor(), context);
        return task;
    }

    public Execution createExecution(ExecutionParameters executionParameters, String taskID) {
        Execution execution = new Execution();
        execution.setStartTime(Long.valueOf(System.currentTimeMillis()));
        execution.setExecutionParameters(executionParameters);
        execution.setStatus(ExecutionStatus.INITIALIZING);
        execution.setAttributes(new HashMap());
        if (executionParameters.getAttributes() != null) {
            execution.getAttributes().putAll(executionParameters.getAttributes());
        }
        if (taskID != null) {
            ExecutiontTaskParameters executiontTaskParameters = (ExecutiontTaskParameters)this.taskAccessor.get(new ObjectId(taskID));
            if (executiontTaskParameters != null && executiontTaskParameters.getAttributes() != null) {
                execution.getAttributes().putAll(executiontTaskParameters.getAttributes());
            }
            execution.setExecutionTaskID(taskID);
        }
        Plan plan = null;
        RepositoryObjectReference repositoryObject = executionParameters.getRepositoryObject();
        if (repositoryObject != null && repositoryObject.getRepositoryParameters().containsKey("planid")) {
            plan = (Plan)this.planAccessor.get(new ObjectId((String)repositoryObject.getRepositoryParameters().get("planid")));
        }
        if (plan != null && plan.getAttributes() != null) {
            execution.setPlanId(plan.getId().toString());
            execution.getAttributes().putAll(plan.getAttributes());
        }
        if (executionParameters.getDescription() != null) {
            execution.setDescription(executionParameters.getDescription());
        }
        this.globalContext.getExecutionAccessor().save((AbstractIdentifiableObject)execution);
        return execution;
    }
}

