/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.HashMap;
import java.util.Map;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionManager;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionStatus;
import step.core.plans.Plan;
import step.core.repositories.ImportResult;

public class ExecutionManagerImpl
implements ExecutionManager {
    private final ExecutionAccessor accessor;

    public ExecutionManagerImpl(ExecutionAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void updateParameters(ExecutionContext context, Map<String, String> params) {
        Execution execution = this.getExecution(context);
        execution.setResult(ReportNodeStatus.RUNNING);
        HashMap<String, String> parameters = execution.getParameters();
        if (parameters == null) {
            parameters = new HashMap<String, String>();
            execution.setParameters(parameters);
        }
        parameters.putAll(params);
        this.saveExecution(execution);
    }

    @Override
    public void persistStatus(ExecutionContext context) {
        Execution execution = this.getExecution(context);
        if (context.getStatus() == ExecutionStatus.ENDED) {
            execution.setEndTime(System.currentTimeMillis());
        }
        execution.setStatus(context.getStatus());
        Plan plan = context.getPlan();
        if (plan != null) {
            execution.setPlanId(plan.getId().toString());
            if (execution.getDescription() == null) {
                execution.setDescription(plan.getAttributes() != null ? (String)plan.getAttributes().get("name") : null);
            }
        }
        this.saveExecution(execution);
    }

    @Override
    public void persistImportResult(ExecutionContext context, ImportResult importResult) {
        Execution execution = this.getExecution(context);
        execution.setImportResult(importResult);
        this.saveExecution(execution);
    }

    @Override
    public void updateStatus(ExecutionContext context, ExecutionStatus status) {
        context.updateStatus(status);
        this.persistStatus(context);
    }

    private void saveExecution(Execution execution) {
        this.accessor.save((AbstractIdentifiableObject)execution);
    }

    private Execution getExecution(ExecutionContext context) {
        Execution execution = (Execution)this.accessor.get(context.getExecutionId());
        return execution;
    }

    @Override
    public void updateExecutionType(ExecutionContext context, String newType) {
        context.setExecutionType(newType);
        Execution execution = this.getExecution(context);
        execution.setExecutionType(newType);
        this.saveExecution(execution);
    }

    @Override
    public void updateExecutionResult(ExecutionContext context, ReportNodeStatus resultStatus) {
        Execution execution = this.getExecution(context);
        execution.setResult(resultStatus);
        this.saveExecution(execution);
    }
}

