/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionManager;
import step.core.execution.model.ExecutionStatus;
import step.core.plugins.ExecutionCallbacks;
import step.core.repositories.ImportResult;

public class ExecutionLifecycleManager {
    private final ExecutionContext context;
    private final ExecutionManager executionManager;
    private final ExecutionCallbacks executionCallbacks;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionLifecycleManager.class);

    public ExecutionLifecycleManager(ExecutionManager executionManager, ExecutionContext context) {
        this.context = context;
        this.executionManager = executionManager;
        this.executionCallbacks = context.getExecutionCallbacks();
    }

    public void abort() {
        if (this.context.getStatus() != ExecutionStatus.ENDED) {
            this.executionManager.updateStatus(this.context, ExecutionStatus.ABORTING);
        }
        this.executionCallbacks.beforeExecutionEnd(this.context);
    }

    public void beforePlanImport() {
        this.executionCallbacks.beforePlanImport(this.context);
    }

    public void afterImport(ImportResult importResult) {
        this.executionManager.persistImportResult(this.context, importResult);
    }

    public void executionStarted() {
        this.executionCallbacks.executionStart(this.context);
    }

    public void executionEnded() {
        this.executionCallbacks.afterExecutionEnd(this.context);
    }

    public void updateStatus(ExecutionStatus newStatus) {
        this.executionManager.updateStatus(this.context, newStatus);
    }

    public void updateExecutionResult(ExecutionContext context, ReportNodeStatus resultStatus) {
        this.executionManager.updateExecutionResult(context, resultStatus);
    }
}

