/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import org.bson.types.ObjectId;
import step.core.GlobalContext;
import step.core.execution.ContextBuilder;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionManager;
import step.core.execution.ExecutionManagerImpl;
import step.core.execution.ExecutionTypeListener;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.plugins.ExecutionCallbacks;
import step.threadpool.ThreadPool;

public class ControllerExecutionContextBuilder {
    private final GlobalContext globalContext;

    public ControllerExecutionContextBuilder(GlobalContext globalContext) {
        this.globalContext = globalContext;
    }

    public ExecutionContext createExecutionContext() {
        return this.createExecutionContext(new ObjectId().toString());
    }

    public ExecutionContext createExecutionContext(String executionId) {
        return this.createExecutionContext(executionId, new ExecutionParameters("dummy", null, ExecutionMode.RUN));
    }

    public ExecutionContext createExecutionContext(String executionId, ExecutionParameters executionParameters) {
        ExecutionContext context;
        boolean isolatedContext = executionParameters.isIsolatedExecution();
        if (isolatedContext) {
            context = ContextBuilder.createLocalExecutionContext((String)executionId);
            context.setReportNodeAccessor(this.globalContext.getReportAccessor());
            context.setEventManager(this.globalContext.getEventManager());
            context.setExecutionCallbacks((ExecutionCallbacks)this.globalContext.getPluginManager().getProxy());
            ExecutionManagerImpl executionManager = new ExecutionManagerImpl(this.globalContext.getExecutionAccessor());
            context.put(ExecutionManager.class, (Object)executionManager);
        } else {
            context = new ExecutionContext(executionId);
            context.setExpressionHandler(this.globalContext.getExpressionHandler());
            context.setDynamicBeanResolver(this.globalContext.getDynamicBeanResolver());
            context.setConfiguration(this.globalContext.getConfiguration());
            context.setPlanAccessor(this.globalContext.getPlanAccessor());
            context.setReportNodeAccessor(this.globalContext.getReportAccessor());
            context.setEventManager(this.globalContext.getEventManager());
            context.setExecutionCallbacks((ExecutionCallbacks)this.globalContext.getPluginManager().getProxy());
            ExecutionManagerImpl executionManager = new ExecutionManagerImpl(this.globalContext.getExecutionAccessor());
            context.put(ExecutionManager.class, (Object)executionManager);
            context.put(ThreadPool.class, (Object)new ThreadPool(context));
            context.setExecutionTypeListener((ExecutionTypeListener)executionManager);
        }
        context.setExecutionParameters(executionParameters);
        context.updateStatus(ExecutionStatus.INITIALIZING);
        return context;
    }
}

