/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.AbstractContext;
import step.core.GlobalContext;
import step.core.deployment.ObjectHookInterceptor;
import step.core.deployment.Session;
import step.core.execution.ExecutionContext;
import step.core.objectenricher.ObjectEnricher;
import step.core.objectenricher.ObjectFilter;
import step.core.objectenricher.ObjectHookRegistry;
import step.core.objectenricher.ObjectPredicate;
import step.core.objectenricher.ObjectPredicateFactory;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.core.ql.Filter;
import step.core.ql.OQLFilterBuilder;

@Plugin
public class ObjectHookPlugin
extends AbstractControllerPlugin {
    private ObjectHookRegistry objectHookRegistry;
    private static final Logger logger = LoggerFactory.getLogger(ObjectHookPlugin.class);

    @Override
    public void executionControllerStart(GlobalContext context) {
        this.objectHookRegistry = new ObjectHookRegistry();
        context.put(ObjectHookRegistry.class, this.objectHookRegistry);
        ObjectPredicateFactory objectPredicateFactory = new ObjectPredicateFactory(this.objectHookRegistry);
        context.put(ObjectPredicateFactory.class, objectPredicateFactory);
        context.getServiceRegistrationCallback().registerService(ObjectHookInterceptor.class);
    }

    public void executionStart(ExecutionContext executionContext) {
        Session session = new Session();
        this.objectHookRegistry.forEach(hook -> {
            try {
                hook.rebuildContext((AbstractContext)session, (Object)executionContext.getExecutionParameters());
            }
            catch (Exception e) {
                logger.error("Error while rebuilding context for execution " + executionContext.getExecutionId(), (Throwable)e);
            }
        });
        executionContext.put(ObjectEnricher.class, (Object)this.objectHookRegistry.getObjectEnricher((AbstractContext)session));
        ObjectFilter objectFilter = this.objectHookRegistry.getObjectFilter((AbstractContext)session);
        executionContext.put(ObjectFilter.class, (Object)objectFilter);
        final Filter filter = OQLFilterBuilder.getFilter((String)objectFilter.getOQLFilter());
        executionContext.put(ObjectPredicate.class, (Object)new ObjectPredicate(){

            public boolean test(Object t) {
                return filter.test(t);
            }
        });
    }
}

