/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.codec.digest.DigestUtils;
import step.core.access.Preferences;
import step.core.access.User;
import step.core.access.UserAccessor;
import step.core.controller.ControllerSetting;
import step.core.controller.ControllerSettingAccessor;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;

@Singleton
@Path(value="admin")
public class AdminServices
extends AbstractServices {
    protected ControllerSettingAccessor controllerSettingsAccessor;
    private static final String MAINTENANCE_MESSAGE_KEY = "maintenance_message";
    private static final String MAINTENANCE_TOGGLE_KEY = "maintenance_message_enabled";
    private static String INITIAL_PWD = "init";

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.controllerSettingsAccessor = new ControllerSettingAccessor(this.controller.getContext().getMongoClientSession());
    }

    @POST
    @Secured(right="user-write")
    @Consumes(value={"application/json"})
    @Path(value="/user")
    public void save(User user) {
        UserAccessor userAccessor = this.getContext().getUserAccessor();
        User previousUser = (User)userAccessor.get(user.getId());
        if (previousUser == null) {
            this.resetPwd(user);
        }
        userAccessor.save(user);
    }

    @DELETE
    @Secured(right="user-write")
    @Path(value="/user/{id}")
    public void remove(@PathParam(value="id") String username) {
        this.getContext().getUserAccessor().remove(username);
    }

    @GET
    @Secured(right="user-read")
    @Path(value="/user/{id}")
    @Produces(value={"application/json"})
    public User getUser(@PathParam(value="id") String username) {
        return this.getContext().getUserAccessor().getByUsername(username);
    }

    @GET
    @Secured(right="user-read")
    @Path(value="/users")
    @Produces(value={"application/json"})
    public List<User> getUserList() {
        return this.getContext().getUserAccessor().getAllUsers();
    }

    @GET
    @Path(value="/maintenance/message")
    public String getMaintenanceMessage() {
        ControllerSetting setting = this.controllerSettingsAccessor.getSettingByKey(MAINTENANCE_MESSAGE_KEY);
        return setting != null ? setting.getValue() : null;
    }

    @POST
    @Secured(right="admin")
    @Path(value="/maintenance/message")
    public void setMaintenanceMessage(String message) {
        ControllerSetting setting = this.controllerSettingsAccessor.getSettingByKey(MAINTENANCE_MESSAGE_KEY);
        if (setting == null) {
            setting = new ControllerSetting();
            setting.setKey(MAINTENANCE_MESSAGE_KEY);
        }
        setting.setValue(message);
        this.controllerSettingsAccessor.save(setting);
    }

    @GET
    @Path(value="/maintenance/message/toggle")
    public boolean getMaintenanceMessageToggle() {
        ControllerSetting setting = this.controllerSettingsAccessor.getSettingByKey(MAINTENANCE_TOGGLE_KEY);
        return setting != null ? Boolean.parseBoolean(setting.getValue()) : false;
    }

    @POST
    @Secured(right="admin")
    @Path(value="/maintenance/message/toggle")
    public void setMaintenanceMessageToggle(boolean enabled) {
        ControllerSetting setting = this.controllerSettingsAccessor.getSettingByKey(MAINTENANCE_TOGGLE_KEY);
        if (setting == null) {
            setting = new ControllerSetting();
            setting.setKey(MAINTENANCE_TOGGLE_KEY);
        }
        setting.setValue(Boolean.toString(enabled));
        this.controllerSettingsAccessor.save(setting);
    }

    @POST
    @Secured
    @Path(value="/myaccount/changepwd")
    public void resetMyPassword(ChangePwdRequest request) {
        User user = this.getCurrentUser();
        if (user != null) {
            user.setPassword(this.encryptPwd(request.getNewPwd()));
            this.getContext().getUserAccessor().save(user);
        }
    }

    protected User getCurrentUser() {
        return (User)this.getContext().getUserAccessor().get(this.getSession().getUser().getId());
    }

    @GET
    @Secured
    @Path(value="/myaccount")
    @Produces(value={"application/json"})
    public User getMyUser() {
        User user = this.getCurrentUser();
        return user;
    }

    @GET
    @Secured
    @Path(value="/myaccount/preferences")
    public Preferences getPreferences() {
        User user = this.getCurrentUser();
        if (user != null) {
            return user.getPreferences();
        }
        return null;
    }

    @POST
    @Secured
    @Path(value="/myaccount/preferences/{id}")
    public void putPreference(@PathParam(value="id") String preferenceName, Object value) {
        User user = this.getCurrentUser();
        if (user != null) {
            if (user.getPreferences() == null) {
                Preferences prefs = new Preferences();
                user.setPreferences(prefs);
            }
            user.getPreferences().put(preferenceName, value);
            this.getContext().getUserAccessor().save(user);
        }
    }

    @POST
    @Secured
    @Path(value="/myaccount/preferences")
    public void putPreference(Preferences preferences) {
        User user = this.getCurrentUser();
        if (user != null) {
            user.setPreferences(preferences);
            this.getContext().getUserAccessor().save(user);
        }
    }

    @POST
    @Secured(right="user-write")
    @Consumes(value={"application/json"})
    @Path(value="/user/{id}/resetpwd")
    public void resetPassword(@PathParam(value="id") String username) {
        User user = this.getContext().getUserAccessor().getByUsername(username);
        this.resetPwd(user);
        this.getContext().getUserAccessor().save(user);
    }

    private void resetPwd(User user) {
        user.setPassword(this.encryptPwd(INITIAL_PWD));
    }

    private String encryptPwd(String pwd) {
        return DigestUtils.sha512Hex((String)pwd);
    }

    public static class ChangePwdRequest {
        private String oldPwd;
        private String newPwd;

        public String getOldPwd() {
            return this.oldPwd;
        }

        public void setOldPwd(String oldPwd) {
            this.oldPwd = oldPwd;
        }

        public String getNewPwd() {
            return this.newPwd;
        }

        public void setNewPwd(String newPwd) {
            this.newPwd = newPwd;
        }
    }
}

