/*
 * Decompiled with CFR 0.152.
 */
package step.core.controller.errorhandling;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.controller.errorhandling.ApplicationException;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;

@Secured
@Provider
public class ErrorFilter
extends AbstractServices
implements ExceptionMapper<Exception> {
    private static final Logger logger = LoggerFactory.getLogger(ErrorFilter.class);

    public Response toResponse(Exception exception) {
        if (exception instanceof ApplicationException) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)((ApplicationException)exception).getErrorMessage()).type("text/plain").build();
        }
        logger.error("Unexpected error while processing request", (Throwable)exception);
        return Response.status((int)500).entity((Object)("Unexepected server error occurred: " + exception.getClass().getName() + ":" + exception.getMessage())).type("text/plain").build();
    }
}

