/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import ch.exense.commons.app.Configuration;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.jongo.Jongo;
import org.jongo.MongoCollection;
import org.jongo.marshall.jackson.JacksonMapper;
import step.core.accessors.AccessorLayerJacksonMapperProvider;

public class MongoClientSession
implements Closeable {
    protected MongoClient mongoClient;
    protected String db;
    protected Configuration configuration;

    public MongoClientSession(Configuration configuration) {
        this.configuration = configuration;
        this.initMongoClient();
    }

    protected void initMongoClient() {
        String host = this.configuration.getProperty("db.host");
        Integer port = this.configuration.getPropertyAsInteger("db.port", Integer.valueOf(27017));
        String user = this.configuration.getProperty("db.username");
        String pwd = this.configuration.getProperty("db.password");
        int maxConnections = this.configuration.getPropertyAsInteger("db.maxConnections", Integer.valueOf(200));
        this.db = this.configuration.getProperty("db.database", "step");
        ServerAddress address = new ServerAddress(host, port.intValue());
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        if (user != null) {
            MongoCredential credential = MongoCredential.createCredential((String)user, (String)this.db, (char[])pwd.toCharArray());
            credentials.add(credential);
        }
        MongoClientOptions.Builder clientOptions = new MongoClientOptions.Builder();
        MongoClientOptions options = clientOptions.connectionsPerHost(maxConnections).build();
        this.mongoClient = new MongoClient(address, credentials, options);
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoClient.getDatabase(this.db);
    }

    public MongoCollection getJongoCollection(String collectionName) {
        DB db = this.mongoClient.getDB(this.db);
        JacksonMapper.Builder builder = new JacksonMapper.Builder();
        AccessorLayerJacksonMapperProvider.getModules().forEach(m -> builder.registerModule(m));
        Jongo jongo = new Jongo(db, builder.build());
        MongoCollection collection = jongo.getCollection(collectionName);
        return collection;
    }

    @Override
    public void close() throws IOException {
        this.mongoClient.close();
    }
}

